/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.sample.shadow;

import com.amazonaws.services.iot.client.AWSIotDevice;
import com.amazonaws.services.iot.client.AWSIotDeviceProperty;
import java.util.Random;

public class ConnectedWindow
extends AWSIotDevice {
    @AWSIotDeviceProperty
    private boolean windowOpen;
    @AWSIotDeviceProperty
    private float roomTemperature;

    public ConnectedWindow(String thingName) {
        super(thingName);
    }

    public boolean getWindowOpen() {
        boolean reportedState = this.windowOpen;
        System.out.println(System.currentTimeMillis() + " >>> reported window state: " + (reportedState ? "open" : "closed"));
        return reportedState;
    }

    public void setWindowOpen(boolean desiredState) {
        this.windowOpen = desiredState;
        System.out.println(System.currentTimeMillis() + " <<< desired window state to " + (desiredState ? "open" : "closed"));
    }

    public float getRoomTemperature() {
        float reportedTemperature;
        Random rand = new Random();
        float minTemperature = 20.0f;
        float maxTemperature = 85.0f;
        this.roomTemperature = reportedTemperature = rand.nextFloat() * (maxTemperature - minTemperature) + minTemperature;
        System.out.println(System.currentTimeMillis() + " >>> reported room temperature: " + reportedTemperature);
        return this.roomTemperature;
    }

    public void setRoomTemperature(float desiredTemperature) {
    }
}

