/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.sample.sampleUtil;

import com.amazonaws.services.iot.client.sample.sampleUtil.PrivateKeyReader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.List;
import java.util.Properties;

public class SampleUtil {
    private static final String PropertyFile = "aws-iot-sdk-samples.properties";

    public static String getConfig(String name) {
        Properties prop = new Properties();
        URL resource = SampleUtil.class.getResource(PropertyFile);
        if (resource == null) {
            return null;
        }
        try (InputStream stream = resource.openStream();){
            prop.load(stream);
        }
        catch (IOException e) {
            return null;
        }
        String value = prop.getProperty(name);
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return value;
    }

    public static KeyStorePasswordPair getKeyStorePasswordPair(String certificateFile, String privateKeyFile) {
        return SampleUtil.getKeyStorePasswordPair(certificateFile, privateKeyFile, null);
    }

    public static KeyStorePasswordPair getKeyStorePasswordPair(String certificateFile, String privateKeyFile, String keyAlgorithm) {
        if (certificateFile == null || privateKeyFile == null) {
            System.out.println("Certificate or private key file missing");
            return null;
        }
        System.out.println("Cert file:" + certificateFile + " Private key: " + privateKeyFile);
        PrivateKey privateKey = SampleUtil.loadPrivateKeyFromFile(privateKeyFile, keyAlgorithm);
        List<Certificate> certChain = SampleUtil.loadCertificatesFromFile(certificateFile);
        if (certChain == null || privateKey == null) {
            return null;
        }
        return SampleUtil.getKeyStorePasswordPair(certChain, privateKey);
    }

    public static KeyStorePasswordPair getKeyStorePasswordPair(List<Certificate> certificates, PrivateKey privateKey) {
        String keyPassword;
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            keyPassword = new BigInteger(128, new SecureRandom()).toString(32);
            Certificate[] certChain = new Certificate[certificates.size()];
            certChain = certificates.toArray(certChain);
            keyStore.setKeyEntry("alias", privateKey, keyPassword.toCharArray(), certChain);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            System.out.println("Failed to create key store");
            return null;
        }
        return new KeyStorePasswordPair(keyStore, keyPassword);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Certificate> loadCertificatesFromFile(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            System.out.println("Certificate file: " + filename + " is not found.");
            return null;
        }
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            List list = (List)certFactory.generateCertificates(stream);
            return list;
        }
        catch (IOException | CertificateException e) {
            System.out.println("Failed to load certificate file " + filename);
            return null;
        }
    }

    private static PrivateKey loadPrivateKeyFromFile(String filename, String algorithm) {
        PrivateKey privateKey = null;
        File file = new File(filename);
        if (!file.exists()) {
            System.out.println("Private key file not found: " + filename);
            return null;
        }
        try (DataInputStream stream = new DataInputStream(new FileInputStream(file));){
            privateKey = PrivateKeyReader.getPrivateKey(stream, algorithm);
        }
        catch (IOException | GeneralSecurityException e) {
            System.out.println("Failed to load private key from file " + filename);
        }
        return privateKey;
    }

    public static class KeyStorePasswordPair {
        public KeyStore keyStore;
        public String keyPassword;

        public KeyStorePasswordPair(KeyStore keyStore, String keyPassword) {
            this.keyStore = keyStore;
            this.keyPassword = keyPassword;
        }
    }
}

