/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.sample.sampleUtil;

import com.amazonaws.services.iot.client.sample.sampleUtil.Asn1Object;
import com.amazonaws.services.iot.client.sample.sampleUtil.DerParser;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import org.apache.commons.codec.binary.Base64;

public class PrivateKeyReader {
    public static final String P1_BEGIN_MARKER = "-----BEGIN RSA PRIVATE KEY";
    public static final String P1_END_MARKER = "-----END RSA PRIVATE KEY";
    public static final String P8_BEGIN_MARKER = "-----BEGIN PRIVATE KEY";
    public static final String P8_END_MARKER = "-----END PRIVATE KEY";

    public static PrivateKey getPrivateKey(String fileName) throws IOException, GeneralSecurityException {
        try (FileInputStream stream = new FileInputStream(fileName);){
            PrivateKey privateKey = PrivateKeyReader.getPrivateKey(stream, null);
            return privateKey;
        }
    }

    public static PrivateKey getPrivateKey(String fileName, String algorithm) throws IOException, GeneralSecurityException {
        try (FileInputStream stream = new FileInputStream(fileName);){
            PrivateKey privateKey = PrivateKeyReader.getPrivateKey(stream, algorithm);
            return privateKey;
        }
    }

    public static PrivateKey getPrivateKey(InputStream stream, String algorithm) throws IOException, GeneralSecurityException {
        PrivateKey key = null;
        boolean isRSAKey = false;
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        StringBuilder builder = new StringBuilder();
        boolean inKey = false;
        String line = br.readLine();
        while (line != null) {
            if (!inKey) {
                if (line.startsWith("-----BEGIN ") && line.endsWith(" PRIVATE KEY-----")) {
                    inKey = true;
                    isRSAKey = line.contains("RSA");
                }
            } else {
                if (line.startsWith("-----END ") && line.endsWith(" PRIVATE KEY-----")) {
                    inKey = false;
                    isRSAKey = line.contains("RSA");
                    break;
                }
                builder.append(line);
            }
            line = br.readLine();
        }
        KeySpec keySpec = null;
        byte[] encoded = Base64.decodeBase64((String)builder.toString());
        keySpec = isRSAKey ? PrivateKeyReader.getRSAKeySpec(encoded) : new PKCS8EncodedKeySpec(encoded);
        KeyFactory kf = KeyFactory.getInstance(algorithm == null ? "RSA" : algorithm);
        key = kf.generatePrivate(keySpec);
        return key;
    }

    private static RSAPrivateCrtKeySpec getRSAKeySpec(byte[] keyBytes) throws IOException {
        DerParser parser = new DerParser(keyBytes);
        Asn1Object sequence = parser.read();
        if (sequence.getType() != 16) {
            throw new IOException("Invalid DER: not a sequence");
        }
        parser = sequence.getParser();
        parser.read();
        BigInteger modulus = parser.read().getInteger();
        BigInteger publicExp = parser.read().getInteger();
        BigInteger privateExp = parser.read().getInteger();
        BigInteger prime1 = parser.read().getInteger();
        BigInteger prime2 = parser.read().getInteger();
        BigInteger exp1 = parser.read().getInteger();
        BigInteger exp2 = parser.read().getInteger();
        BigInteger crtCoef = parser.read().getInteger();
        RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
        return keySpec;
    }
}

