/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.sample.sampleUtil;

import java.util.HashMap;
import java.util.Map;

public class CommandArguments {
    private final Map<String, String> arguments = new HashMap<String, String>();

    private CommandArguments(String[] args) {
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (name == null) {
                if (!arg.startsWith("-") || (name = arg.replaceFirst("^-+", "")).length() >= 1) continue;
                name = null;
                continue;
            }
            if (arg.startsWith("-")) {
                this.arguments.put(name.toLowerCase(), null);
                name = arg.replaceFirst("^-+", "");
                if (name.length() >= 1) continue;
                name = null;
                continue;
            }
            this.arguments.put(name.toLowerCase(), arg);
            name = null;
        }
        if (name != null) {
            this.arguments.put(name.toLowerCase(), null);
        }
    }

    public static CommandArguments parse(String[] args) {
        return new CommandArguments(args);
    }

    public String get(String name) {
        return this.arguments.get(name.toLowerCase());
    }

    public String get(String name, String defaultValue) {
        String value = this.arguments.get(name.toLowerCase());
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getNotNull(String name) {
        String value = this.get(name);
        if (value == null) {
            throw new RuntimeException("Missing required argument for " + name);
        }
        return value;
    }

    public String getNotNull(String name, String defaultValue) {
        String value = this.get(name, defaultValue);
        if (value == null) {
            throw new RuntimeException("Missing required argument for " + name);
        }
        return value;
    }
}

