package com.openfin.desktop.win32;


import com.openfin.desktop.RuntimeLauncher;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.VerRsrc;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;
import java.rmi.registry.Registry;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class InstallChecker {
    private final static Logger logger = LoggerFactory.getLogger(InstallChecker.class.getName());


    private static String getFileVersion(String path) {
        String version = null;
        if (path != null) {
            try {
                IntByReference dwDummy = new IntByReference();
                dwDummy.setValue(0);

                int versionlength = com.sun.jna.platform.win32.Version.INSTANCE.GetFileVersionInfoSize(path, dwDummy);

                byte[] bufferarray = new byte[versionlength];
                Pointer lpData = new Memory(bufferarray.length);
                PointerByReference lplpBuffer = new PointerByReference();
                IntByReference puLen = new IntByReference();
                boolean fileInfoResult = com.sun.jna.platform.win32.Version.INSTANCE.GetFileVersionInfo(path, 0, versionlength, lpData);
                boolean verQueryVal = com.sun.jna.platform.win32.Version.INSTANCE.VerQueryValue(lpData, "\\", lplpBuffer, puLen);

                VerRsrc.VS_FIXEDFILEINFO lplpBufStructure = new VerRsrc.VS_FIXEDFILEINFO(lplpBuffer.getValue());
                lplpBufStructure.read();

                int v1 = (lplpBufStructure.dwFileVersionMS).intValue() >> 16;
                int v2 = (lplpBufStructure.dwFileVersionMS).intValue() & 0xffff;
                int v3 = (lplpBufStructure.dwFileVersionLS).intValue() >> 16;
                int v4 = (lplpBufStructure.dwFileVersionLS).intValue() & 0xffff;
                version = String.format("%d.%d.%d.%d", v1, v2, v3, v4);
            } catch (Exception e) {
                logger.debug(String.format("Error getting file version info %s", path), e);
            }
        }
        return version;
    }

    private static void checkRVM(JSONObject result) {
        String path = RuntimeLauncher.getExistingRVM();
        String version = getFileVersion(path);
        if (path != null) {
            JSONObject rvm = new JSONObject();
            rvm.put("path", path);
            rvm.put("version", version);
            result.put("rvm", rvm);
        }
    }

    private static void checkRuntime(JSONObject result) {
        String path = RegistryHelper.getRuntimeInstallDirectory();
        if (path != null) {
            JSONArray array = new JSONArray();
            String versionPattern = "^(\\d+\\.)(\\d+\\.)(\\d+\\.)(\\d+)$";
            File dir = new File(path);
            List<File> list = Arrays.asList(dir.listFiles());
            list.forEach((ele) -> {
                if (ele.isDirectory() && Pattern.matches(versionPattern, ele.getName())) {
                    JSONObject runtime = new JSONObject();
                    String version = getRuntimeVersion(ele.getPath());
                    runtime.put("path", ele.getPath());
                    if (version != null) {
                        runtime.put("version", version);
                    } else {
                        runtime.put("version", "not available");
                    }
                    array.put(array.length(), runtime);
                }
            });
            if (array.length() > 0){
                result.put("runtime", array);
            }
        }
    }

    private static String getRuntimeVersion(String path) {
        String exePath = path + File.separator + "OpenFin"  + File.separator + "openfin.exe";
        return getFileVersion(exePath);
    }

    public static JSONObject getInstallInfo() {
        JSONObject result = new JSONObject();
        checkRVM(result);
        checkRuntime(result);
        return result;
    }

    public static void main(String[] args) throws IOException {
        System.out.println(getInstallInfo().toString());
    }

}
