package com.openfin.desktop.platform;

import java.util.concurrent.CompletableFuture;

import org.json.JSONObject;

import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.Identity;
import com.openfin.desktop.WebContent;
import com.openfin.desktop.Window;

public class PlatformView extends WebContent {
	
	public PlatformView(Identity identity, DesktopConnection connection) {
		super(identity, connection);
	}
	
	public static PlatformView wrap(Identity identity, DesktopConnection desktopConnection) {
		return new PlatformView(identity, desktopConnection);
	}
	
	public CompletableFuture<Window> getCurrentWindow() {
		return this.connection.sendActionAsync("get-view-window", this.identity.getJsonCopy(), this).thenApplyAsync(ack->{
			if (ack.isSuccessful()) {
				JSONObject windowIdentity = ack.getJsonObject().getJSONObject("data");
				return Window.wrap(windowIdentity.optString("uuid", null), windowIdentity.optString("name", null), this.connection);
			}
			else {
				throw new RuntimeException("unable to get current window of the view, reason: " + ack.getReason());
			}
		}); 
	}
	
	public CompletableFuture<PlatformView> setBounds(int left, int top, int width, int height) {
		JSONObject bounds = new JSONObject();
		bounds.put("left", left);
		bounds.put("top", top);
		bounds.put("width", width);
		bounds.put("height", height);
		
		JSONObject payload = new JSONObject();
		
		payload.put("uuid", this.identity.getUuid());
		payload.put("name", this.identity.getName());
		payload.put("bounds", bounds);
		
		return this.connection.sendActionAsync("set-view-bounds", payload, this).thenApplyAsync(ack->{
			if (ack.isSuccessful()) {
				return this;
			}
			else {
				throw new RuntimeException("unable to get current window of the view, reason: " + ack.getReason());
			}
		}); 
	}
	
	public CompletableFuture<PlatformViewOptions> getOptions() {
		return this.connection.sendActionAsync("get-view-options", this.identity.getJsonCopy(), this).thenApplyAsync(ack->{
			return new PlatformViewOptions(ack.getJsonObject().getJSONObject("data"));
		});
	}

	@Override
	protected String getEventTopicName() {
		return "view";
	}
}
