package com.openfin.desktop.fdc3;

import org.json.JSONObject;

/**
 * Context can be summarised as:
 * Having a unique type identifier, used for routing.
 * Optionally providing a name.
 * Optionally providing a map of equivalent identifiers.
 * Any other properties or metadata.
 * @author Anthony
 *
 */
public class Context extends JSONObject {

    public Context(String type) {
        this(type, null);
    }

    public Context(String type, String name) {
        this.put("type", type);
        if (name != null) {
            this.put("name", name);
        }
    }

    public String getType() {
        return this.getString("type");
    }

    public String getName() {
        return this.getString("name");
    }

    public void setId(JSONObject id) {
        this.put("id", id);
    }

    public static Context fromJson(JSONObject jsonObject) {
        Context context = new Context(jsonObject.getString("type"), jsonObject.getString("name"));
        if (jsonObject.has("id")) {
            context.setId(jsonObject.getJSONObject("id"));
        }
        return context;
    }
}
