package com.openfin.desktop.fdc3;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.AsyncCallback;
import com.openfin.desktop.WindowIdentity;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channel {
    protected Logger logger = LoggerFactory.getLogger(this.getClass().getName());

    private String id;
    private String name;
    private FDC3Client fdc3Client;
    private ContextListener contextListener;

    private final static String ChannelGetMembers = "CHANNEL-GET-MEMBERS";
    private final static String ChannelAddContextListener = "CHANNEL-ADD-CONTEXT-LISTENER";
    private final static String ChannelJOIN = "CHANNEL-JOIN";
    private final static String ChannelGetCurrentContext = "CHANNEL-GET-CURRENT-CONTEXT";

    Channel(String id, FDC3Client fdc3Client) {
        this.id = id;
        this.fdc3Client = fdc3Client;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void getCurrentContext(AsyncCallback<Context> callback) {
        JSONObject payload = createPayload();
        this.fdc3Client.serviceDispatch(ChannelGetCurrentContext, payload, new AckListener() {
            @Override
            public void onSuccess(Ack ack) {
                Context c = Context.fromJson(ack.getJsonObject());
                callback.onSuccess(c);
            }
            @Override
            public void onError(Ack ack) {
                callback.onSuccess(null);
            }
        });
    }

    public void join(AckListener listener) {
        join(null, listener);
    }

    private void join(WindowIdentity identity, AckListener listener) {
        JSONObject payload = createPayload();
        if (identity != null) {
            payload.put("identity", identity.toJsonObject());
        }
        this.fdc3Client.serviceDispatch(ChannelJOIN, payload, listener);
    }

    private void setContextListener(ContextListener contextListener, AckListener listener) {
        if (this.contextListener == null) {
            this.fdc3Client.addChannelContextListener(this.id, contextListener);
            this.contextListener = contextListener;
            JSONObject payload = createPayload();
            this.fdc3Client.serviceDispatch(ChannelAddContextListener, payload, listener);
        } else {
            logger.warn(String.format("Channel listener already set %s", this.id));
        }
    }

    private JSONObject createPayload() {
        JSONObject payload = new JSONObject();
        payload.put("id", this.id);
        return payload;
    }
}
