package com.openfin.desktop.fdc3;

import java.util.List;

public class AppIntent {
	
	private IntentMetadata intentMetadata;
	private List<AppMetadata> apps;

	public AppIntent(IntentMetadata intentMetadata, List<AppMetadata> apps) {
		this.intentMetadata = intentMetadata;
		this.apps = apps;
	}

	public IntentMetadata getIntentMetadata() {
		return intentMetadata;
	}

	public List<AppMetadata> getApps() {
		return apps;
	}
	
	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("intent.name=").append(this.intentMetadata.getName()).append(", intent.displayName=").append(this.intentMetadata.getDisplayName());
		for (int i=0; i<apps.size(); i++) {
			sb.append(", apps[").append(i).append("].name=").append(apps.get(i).getName());
		}
		
		return sb.toString();
	}
	
}
