package com.openfin.desktop.channel;

import com.openfin.desktop.JsonUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationOptions {
    private final static Logger logger = LoggerFactory.getLogger(NotificationOptions.class.getName());

    private JSONObject options = new JSONObject();

    private static String ID = "id";
    private static String BODY = "body";
    private static String TITLE = "title";
    private static String SUBTIILE = "subtitle";
    private static String ICON = "icon";
    private static String CUSTOMDATA = "customData";
    private static String BUTTONS = "buttons";

    private int buttonIndex;  // set in NotificationButtonClicked event

    public NotificationOptions() {
    }

    public void setId(String id) {
        options.put(ID, id);
    }

    public String getId() {
        return JsonUtils.getStringValue(this.options, ID, null);
    }

    public void setBody(String body) {
        options.put(BODY, body);
    }

    public String getBody() {
        return JsonUtils.getStringValue(this.options, BODY, null);
    }

    public void setTitle(String title) {
        options.put(TITLE, title);
    }

    public String getTitle() {
        return JsonUtils.getStringValue(this.options, TITLE, null);
    }

    public void setSubtitle(String subtitle) {
        options.put(SUBTIILE, subtitle);
    }

    public String getSubtitle() {
        return JsonUtils.getStringValue(this.options, SUBTIILE, null);
    }

    public void setIcon(String icon) {
        options.put(ICON, icon);
    }

    public String getIcon() {
        return JsonUtils.getStringValue(this.options, ICON, null);
    }

    public void setCustomData(JSONObject customData) {
        options.put(CUSTOMDATA, customData);
    }

    public JSONObject getCustomData() {
        return (JSONObject) JsonUtils.getJsonValue(this.options, CUSTOMDATA, null);
    }

    public synchronized void addButton(String url, String title) {
        JSONArray buttons = JsonUtils.getJsonArray(this.options, BUTTONS, null);
        if (buttons == null) {
            buttons = new JSONArray();
            this.options.put(BUTTONS, buttons);
        }
        JSONObject b = new JSONObject();
        JsonUtils.updateValue(b, "iconUrl", url);
        JsonUtils.updateValue(b, "title", title);
        buttons.put(buttons.length(), b);
    }

    public JSONObject getJson() {
        return this.options;
    }

    public static NotificationOptions fromJson(JSONObject json) {
        NotificationOptions options = null;
        if (json != null){
            options = new NotificationOptions();
            options.setId(JsonUtils.getStringValue(json, ID, null));
            options.setBody(JsonUtils.getStringValue(json, BODY, null));
            options.setTitle(JsonUtils.getStringValue(json, TITLE, null));
            options.setSubtitle(JsonUtils.getStringValue(json, SUBTIILE, null));
            options.setIcon(JsonUtils.getStringValue(json,ICON, null));
            options.setCustomData((JSONObject) JsonUtils.getJsonValue(json, CUSTOMDATA, null));
        }
        return options;
    }

    public NotificationOptions put(String key, Object value) {
        this.options.put(key, value);
        return this;
    }

    public int getButtonIndex() {
        return buttonIndex;
    }

    public void setButtonIndex(int buttonIndex) {
        this.buttonIndex = buttonIndex;
    }
}
