package com.openfin.desktop.channel;

import java.util.concurrent.CompletableFuture;

import org.json.JSONObject;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;

public class ChannelClient extends ChannelBase {

	ChannelClient(Channel messageChannelFactory, EndpointIdentity endpointIdentity) {
		super(messageChannelFactory, endpointIdentity);
	}

	/**
	 * Dispatch the given action to the channel provider.
	 * 
	 * @param action
	 *            Name of the action to be invoked by the channel provider.
	 * @param actionPayload
	 *            Payload to be sent along with the action.
	 * @param ackListener
	 *            AckListener for the request
	 */
	public void dispatch(String action, JSONObject actionPayload, AckListener ackListener) {
		//channel provider endpointIdentity would not have endpointId
		EndpointIdentity providerIdentity = new EndpointIdentity(this.endpointIdentity.getChannelName(), this.endpointIdentity.getChannelId(), this.endpointIdentity.getUuid(), this.endpointIdentity.getName(), null);
		super.dispatch(providerIdentity.toJSON(), action, actionPayload, ackListener);
	}
	
	public CompletableFuture<Ack> dispatchAsync(String action, JSONObject actionPayload) {
		EndpointIdentity providerIdentity = new EndpointIdentity(this.endpointIdentity.getChannelName(), this.endpointIdentity.getChannelId(), this.endpointIdentity.getUuid(), this.endpointIdentity.getName(), null);
		return super.dispatchAsync(providerIdentity.toJSON(), action, actionPayload);
	}
	
	/**
	 * Register an action to be called by ChannelProvider
	 * @param action Name of the action to be invoked by the channel provider
	 * @param listener Function representing the action to be taken on a client dispatch.
	 * @return if the action was registered successfully
	 */
	public boolean register(String action, ChannelAction listener) {
		return super.register(action, listener);
	}
	
	/**
	 * Disconnect from the channel.
	 * @param ackListener AckListener for the request
	 */
	public void disconnect(AckListener ackListener) {
		this.channel.disconnect(this,  ackListener);
	}
}
