package com.openfin.desktop.channel;

import org.json.JSONObject;

/**
 * The ChannelAction interface should be implemented when registering actions by {@link ChannelProvider} or {@link ChannelClient}
 * @author Anthony
 *
 */
@FunctionalInterface
public interface ChannelAction {
	/**
	 * Channel action to be invoked.
	 * @param action Name of the action to be registered
	 * @param payload Payload sent along when invoking the action.
	 * @param senderIdentity Identity of the sender.
	 * @return Result by invoking the action..
	 */
	public JSONObject invoke(String action, JSONObject payload, JSONObject senderIdentity);
}
