package com.openfin.desktop.animation;

import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * A class representing a transition of a Window's dimensions.
 * The Width property represents the resulting width of the window
 * The Height property represents the resulting height of the window
 * The Duration property represents the total time in milliseconds for the transition to complete.
 */
public class SizeTransition extends AbstractAnimation {
    private final static Logger logger = LoggerFactory.getLogger(SizeTransition.class.getName());

    public SizeTransition() {
    }

    public SizeTransition(Integer width, Integer height, Integer duration) {
        this.setWidth(width);
        this.setHeight(height);
        this.setDuration(duration);
    }

    /**
     * Gets value of width
     * @return Value of width
     */
    public Integer getWidth() {
        Integer value = null;
        try {
            value = this.jsonObject.getInt("width");
        } catch (Exception e) {
            logger.error("Error getting width", e);
        }
        return value;
    }

    /**
     * Sets value of width
     * @param width Value of width
     */
    public void setWidth(Integer width) {
        try {
            this.jsonObject.put("width", width);
        } catch (Exception e) {
            logger.error("Error setting width", e);
        }
    }

    /**
     * Gets value of height
     * @return Value of height
     */
    public Integer getHeight() {
        Integer value = null;
        try {
            value = this.jsonObject.getInt("height");
        } catch (Exception e) {
            logger.error("Error getting height", e);
        }
        return value;
    }

    /**
     * Sets value of height
     * @param height Value of height
     */
    public void setHeight(Integer height) {
        try {
            this.jsonObject.put("height", height);
        } catch (Exception e) {
            logger.error("Error setting height", e);
        }
    }

    /**
     * Gets value of duration
     * @return Value of duration
     */
    public Integer getDuration() {
        Integer value = null;
        try {
            value = this.jsonObject.getInt("duration");
        } catch (Exception e) {
            logger.error("Error getting duration", e);
        }
        return value;
    }

    /**
     * Sets value of duration
     * @param duration Value of duration
     */
    public void setDuration(Integer duration) {
        try {
            this.jsonObject.put("duration", duration);
        } catch (Exception e) {
            logger.error("Error setting duration", e);
        }
    }

}
