package com.openfin.desktop.animation;

import org.json.JSONObject;

/**
 * A class representing the options for a Window animation.
 */

public class AnimationOptions {
    private JSONObject options = new JSONObject();
    private Boolean interrupt = Boolean.TRUE;

    /**
     * Constructs an instance with the passed value for property Interrupt
     * @param interrupt Value for interrupt
     */
    public AnimationOptions(Boolean interrupt) {
        this.interrupt = interrupt;
    }

    /**
     * Gets value of interrupt
     * The Interrupt property represents a flag which determines if a call to Window.animate
     * will interrupt all pending transitions, or add itself to the queue.
     * @return Value of interrup
     */
    public Boolean getInterrupt() {
        return this.interrupt;
    }

    /**
     * Gets options in JSON format
     * @return JSONObject of options
     */
    public JSONObject getOptions() {
        return this.options;
    }

}
