package com.openfin.desktop;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *  An object representing the core of the OpenFin Desktop. Allows the developer to
 *  perform system-level actions, such as accessing logs, viewing processes, clearing
 *  the cache and exiting the Desktop.
 *
 * @deprecated replaced by {@link com.openfin.desktop.OpenFinRuntime}
 *
 */
public class System extends OpenFinRuntime {
    private static Logger logger = LoggerFactory.getLogger(System.class.getName());

    /**
     * Constructor
     * @param connection Connection object to the AppDesktop
     * @see DesktopConnection
     */
    public System(DesktopConnection connection) {
        super(connection);
    }

    /**
     * Get version info of java adapter
     *
     * @return version information
     */
    public static String getAdapterVersion() {
        return OpenFinRuntime.getAdapterVersion();
    }

    /**
     * Get build time of java adapter
     *
     * @return build time
     */
    public static String getAdapterBuildTime() {
        return OpenFinRuntime.getAdapterBuildTime();
    }
}
