package com.openfin.desktop;

import org.json.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Helper object that provides getters/setters for the
 * various options needed for creating a Notification.
 * @since 2/10/14
 */
public class NotificationOptions {
    private final static Logger logger = LoggerFactory.getLogger(NotificationOptions.class.getName());

    private JSONObject options;

    public NotificationOptions(String url) {
        this.options = new JSONObject();
        if (url != null) {
            this.setURL(url);
        }
    }

    /**
     * Gets URL property of the notification
     * @return URL
     */
    public String getURL() {
        return JsonUtils.getStringValue(this.options, "url", null);
    }

    /**
     * Sets URL property of the notification
     *
     * @param url URL of the notification
     */
    public void setURL(String url) {
        try {
            this.options.put("url", url);
        } catch (Exception e) {
            logger.error("Error setting URL", e);
        }
    }

    /**
     * Gets Message property of the notification
     *
     * @return message property
     */
    public JSONObject getMessage() {
        return JsonUtils.getJsonValue(this.options, "message", null);
    }

    /**
     * Sets Message property of the notification
     *
     * @param message value of message
     */
    public void setMessage(JSONObject message) {
        try {
            this.options.put("message", message);
        } catch (Exception e) {
            logger.error("Error setting message", e);
        }
    }

    /**
     * Gets Message property of the notification as String
     *
     * @return message string
     */
    public String getMessageText() {
        return JsonUtils.getStringValue(this.options, "message", null);
    }

    /**
     * Sets Message property of the notification as String
     *
     * @param message text of the message
     */
    public void setMessageText(String message) {
        try {
        	JSONObject msgObj = new JSONObject();
        	msgObj.put("message", message);
            this.options.put("message", msgObj);
        } catch (Exception e) {
            logger.error("Error setting message", e);
        }
    }

    /**
     * Gets timeout property of the notification
     *
     * @return timeout in milliseconds
     */
    public Integer getTimeout() {
        return JsonUtils.getIntegerValue(this.options, "timeout", null);
    }

    /**
     * Sets timeout property of the notification
     *
     * @param timeout in milliseconds
     */
    public void setTimeout(Integer timeout) {
        try {
            this.options.put("timeout", timeout);
        } catch (Exception e) {
            logger.error("Error setting timeout", e);
        }
    }

}
