package com.openfin.desktop;

/**
 * Defines a listener for notification events.
 * @author wche
 * @since 2/9/14
 */
public interface NotificationListener {
    /**
     * Invoked when the notification is clicked.
     * @param ack an Ack object
     * @see Ack
     */
    public void onClick(Ack ack);

    /**
     * Invoked when the notification is closed.
     * @param ack an Ack object
     * @see Ack
     */
    public void onClose(Ack ack);

    /**
     * Invoked when the notification is dismissed.
     * @param ack an Ack object
     * @see Ack
     */
    public void onDismiss(Ack ack);

    /**
     * Invoked when the notification has errors.
     * @param ack an Ack object
     * @see Ack
     */
    public void onError(Ack ack);

    /**
     * Invoked when the notification sends a message.
     * @param ack an Ack object
     * @see Ack
     */
    public void onMessage(Ack ack);

    /**
     * Invoked when the notification is being shown
     * @param ack an Ack object
     * @see Ack
     */
    public void onShow(Ack ack);
}
