package com.openfin.desktop;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONObject;

public class LayoutOptions extends JsonBean {
	private JsonBean settings;
	private List<LayoutContentOptions> content;
	
	public LayoutOptions() {
		super();
	}
	
	public LayoutOptions(JSONObject json) {
		super(json);
		if (this.json.has("settings")) {
			this.settings = new JsonBean(json.getJSONObject("settings"));
		}
		this.getContent();
	}
	
	public List<LayoutContentOptions> getContent() {
		if (this.content == null && this.json.has("content")) {
			this.content = new ArrayList<>(this.getJsonBeanList("content", LayoutContentOptionsImpl.class));
		}
		return this.content;
	}
	
	public void setContent(LayoutContentOptions ... contentOptions) {
		this.content = new ArrayList<>(contentOptions.length);
		for (LayoutContentOptions opt : contentOptions) {
			this.content.add(opt);
		}
	}
	
	public void setContent(List<LayoutContentOptions> content) {
		this.content = content;
	}
	
	@Override
	public JSONObject getJson() {
		this.setJsonBean("settings", this.settings);
		this.setJsonArray("content", this.content);
		return super.getJson();
	}
}
