package com.openfin.desktop;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONObject;

public class LayoutContentOptionsImpl extends JsonBean implements LayoutContentOptions {
	
	private List<LayoutContentOptions> content;
	
	public LayoutContentOptionsImpl() {
	}
	
	public LayoutContentOptionsImpl(JSONObject json) {
		super(json);
		this.getContent();
	}
	
	@Override
	public String getType() {
		return this.getString("type");
	}
	
	public void setType(String type) {
		this.setString("type", type);
	}
	
	public String getComponentName() {
		return this.getString("componentName");
	}
	
	public void setComponentName(String componentName) {
		this.setString("componentName", componentName);
	}
	
	@Override
	public List<LayoutContentOptions> getContent() {
		if (this.content == null && this.json.has("content")) {
			this.content = new ArrayList<>(this.getJsonBeanList("content", LayoutContentOptionsImpl.class));
		}
		return this.content;
	}
	
	public void setContent(LayoutContentOptions ... contentOptions) {
		this.content = new ArrayList<>(contentOptions.length);
		for (LayoutContentOptions opt : contentOptions) {
			this.content.add(opt);
		}
	}
	
	public void setContent(List<LayoutContentOptions> content) {
		this.content = content;
	}
	
	@Override
	public JSONObject getJson() {
		this.setJsonArray("content", this.content);
		return super.getJson();
	}
	
}
