package com.openfin.desktop;

import org.json.JSONObject;

public class LayoutContentItemOptions extends LayoutContentOptionsImpl {
	
	private LayoutContentItemStateOptions componentState;
	
	public LayoutContentItemOptions() {
		super();
	}
	
	public LayoutContentItemOptions(JSONObject json) {
		super(json);
	}
	
	public String getTitle() {
		return this.getString("title");
	}
	
	public void setTitle(String title) {
		this.setString("title", title);
	}
	
	public void setProcessAffinity(String processAffinity) {
		this.setString("processAffinity", processAffinity);
	}

	public LayoutContentItemStateOptions getLayoutContentItemStateOptions() {
		if (this.componentState == null && this.json.has("componentState")) {
			this.componentState = this.getJsonBean(this.json.getJSONObject("componentState"), LayoutContentItemStateOptions.class);
		}
		return this.componentState;
	}
	
	public void setLayoutContentItemStateOptions(LayoutContentItemStateOptions componentState) {
		this.componentState = componentState;
	}
	
	@Override
	public JSONObject getJson() {
		this.setJsonBean("componentState", this.componentState);
		return super.getJson();
	}
}
