package com.openfin.desktop;

/**
 * Interface which listens for acknowledgement of messages sent to AppDesktop.
 * @see Ack
 */
public interface AckListener {
    /**
     * Invoked when the request to AppDesktop is successful
     * @param ack an Ack object
     * @see Ack
     */
    abstract public void onSuccess(Ack ack);

    /**
     * Invoked when the request to AppDesktop has errors
     * @param ack an Ack object
     * @see Ack
     */
    abstract public void onError(Ack ack);

}
