package com.openfin.desktop;

import org.json.JSONObject;

/**
 * Window creation options that enable keyboard shortcuts for devtools, zoom, reload, and reload ignoring cache.
 * @author Anthony
 *
 */
public class AcceleratorOptions extends JsonBean {
	
	public AcceleratorOptions() {
		
	}

	public AcceleratorOptions(JSONObject json) {
		super(json);
	}

	/**
	 * Get devtools keyboard shortcut setting.
	 * @return true if shortcut is enabled.
	 */
	public boolean isDevtools() {
		return this.getBooleanValue("devtools");
	}

	/**
	 * Enables/Disables devtools keyboard shortcut: 
	 * Ctrl + Shift + I (Toggles Devtools)
	 * @param devTools If true, enables the devtools keyboard shortcut.
	 */
	public void setDevtools(boolean devTools) {
		this.setBoolean("devtools", devTools);
	}

	/**
	 * Get reload keyboard shortcut setting
	 * @return true if shortcut is enabled.
	 */
	public boolean isReload() {
		return this.getBooleanValue("reload");
	}

	/**
	 * Enables/Disables reload keyboard shortcuts: 
	 * Ctrl + R (Windows) 
	 * F5 (Windows) 
	 * Command + R (Mac)
	 * @param reload If true, enables the reload keyboard shortcuts.
	 */
	public void setReload(boolean reload) {
		this.setBoolean("reload", reload);
	}

	/**
	 * Get reload-from-source keyboard shortcut setting
	 * @return true if shortcut is enabled.
	 */
	public boolean isReloadIgnoringCache() {
		return this.getBooleanValue("reloadIgnoringCache");
	}

	/**
	 * Enables/Disables reload-from-source keyboard shortcut:
	 * Ctrl + Shift + R (Windows)
	 * Shift + F5 (Windows)
	 * Command + Shift + R (Mac)
	 * @param reloadIgnoringCache If true, enables the reload-from-source keyboard shortcuts.
	 */
	public void setReloadIgnoringCache(boolean reloadIgnoringCache) {
		this.setBoolean("reloadIgnoringCache", reloadIgnoringCache);
	}

	/**
	 * Get zoom keyboard shortcut setting
	 * @return true if shortcut is enabled.
	 */
	public boolean isZoom() {
		return this.getBooleanValue("zoom");
	}

	/**
	 * Enables/Disables zoom keyboard shortcut: 
	 * Ctrl + + (Zoom In)
	 * Ctrl + Shift + + (Zoom In)
	 * Ctrl + - (Zoom Out)
	 * Ctrl + Shift + - (Zoom Out)
	 * Ctrl + Scroll (Zoom In &amp; Out)
	 * Ctrl + 0 (Restore to 100%)
	 * @param zoom If true, enables the zoom keyboard shortcuts.
	 */
	public void setZoom(boolean zoom) {
		this.setBoolean("zoom", zoom);
	}

}
