/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.AsyncCallback;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.channel.ChannelBase;
import com.openfin.desktop.channel.ChannelClient;
import com.openfin.desktop.channel.ChannelListener;
import com.openfin.desktop.channel.ChannelProvider;
import com.openfin.desktop.channel.ConnectionEvent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channel {
    private static final Logger logger = LoggerFactory.getLogger((String)Channel.class.getName());
    private DesktopConnection desktopConnection;
    private ConcurrentHashMap<String, ChannelProvider> providerMap;
    private ConcurrentHashMap<String, ChannelClient> clientMap;
    private CopyOnWriteArrayList<ChannelListener> channelListeners;

    public Channel(DesktopConnection desktopConnection) {
        this.desktopConnection = desktopConnection;
        this.providerMap = new ConcurrentHashMap();
        this.clientMap = new ConcurrentHashMap();
        this.channelListeners = new CopyOnWriteArrayList();
    }

    public void create(String channelName, final AsyncCallback<ChannelProvider> callback) {
        JSONObject payload = new JSONObject();
        payload.put("channelName", (Object)channelName);
        this.desktopConnection.sendAction("create-channel", payload, new AckListener(){

            @Override
            public void onSuccess(Ack ack) {
                JSONObject providerIdentity = (JSONObject)ack.getData();
                ChannelProvider provider = new ChannelProvider(Channel.this, providerIdentity);
                Channel.this.providerMap.put(providerIdentity.getString("channelId"), provider);
                callback.onSuccess(provider);
            }

            @Override
            public void onError(Ack ack) {
                logger.error("error connecting to channel: {}", (Object)ack.getReason());
            }
        }, this);
    }

    public void destroy(ChannelBase provider, AckListener ackListener) {
        JSONObject payload = new JSONObject();
        payload.put("channelName", (Object)provider.getChannelName());
        this.desktopConnection.sendAction("destroy-channel", payload, ackListener, this);
    }

    public void connect(final String channelName, final AsyncCallback<ChannelClient> callback) {
        JSONObject payload = new JSONObject();
        payload.put("channelName", (Object)channelName);
        this.desktopConnection.sendAction("connect-to-channel", payload, new AckListener(){

            @Override
            public void onSuccess(Ack ack) {
                JSONObject providerIdentity = (JSONObject)ack.getData();
                String channelId = providerIdentity.getString("channelId");
                String uuid = providerIdentity.getString("uuid");
                String name = providerIdentity.has("name") ? providerIdentity.getString("name") : providerIdentity.getString("uuid");
                ChannelClient client = new ChannelClient(Channel.this, providerIdentity);
                Channel.this.clientMap.put(channelId, client);
                callback.onSuccess(client);
                Channel.this.fireChannelConnectEvent(channelId, uuid, name, channelName);
            }

            @Override
            public void onError(Ack ack) {
                logger.error("error connecting to channel: {}", (Object)ack.getReason());
            }
        }, this);
    }

    public void disconnect(final ChannelBase client, final AckListener ackListener) {
        JSONObject payload = new JSONObject();
        payload.put("channelName", (Object)client.getChannelName());
        this.desktopConnection.sendAction("disconnect-from-channel", payload, new AckListener(){

            @Override
            public void onSuccess(Ack ack) {
                if (ackListener != null) {
                    ackListener.onSuccess(ack);
                }
                Channel.this.fireChannelDisconnectEvent(client.getChannelId(), client.getUuid(), client.getName(), client.getChannelName());
            }

            @Override
            public void onError(Ack ack) {
                ackListener.onError(ack);
            }
        }, this);
    }

    void sendChannelMessage(String action, JSONObject destionationIdentity, JSONObject providerIdentity, JSONObject actionPayload, AckListener ackListener) {
        JSONObject payload = new JSONObject(destionationIdentity, new String[]{"name", "uuid", "channelId", "channelName"});
        payload.put("providerIdentity", (Object)providerIdentity);
        payload.put("action", (Object)action);
        payload.put("payload", (Object)actionPayload);
        this.desktopConnection.sendAction("send-channel-message", payload, ackListener, this);
    }

    public boolean hasProvider(String channelId) {
        return this.providerMap.containsKey(channelId);
    }

    public boolean hasClient(String channelId) {
        return this.clientMap.containsKey(channelId);
    }

    public boolean hasRegisteredAction(String channelId, String action) {
        boolean b = false;
        if (this.providerMap.containsKey(channelId)) {
            ChannelProvider provider = this.providerMap.get(channelId);
            b = provider.hasRegisteredAction(action);
        }
        if (this.clientMap.containsKey(channelId)) {
            ChannelClient client = this.clientMap.get(channelId);
            b |= client.hasRegisteredAction(action);
        }
        return b;
    }

    public JSONObject invokeAction(String channelId, String action, JSONObject actionPayload, JSONObject senderIdentity) {
        ChannelProvider provider = this.providerMap.get(channelId);
        if (provider != null && provider.hasRegisteredAction(action)) {
            return provider.invokeAction(action, actionPayload, senderIdentity);
        }
        ChannelClient client = this.clientMap.get(channelId);
        if (client != null && client.hasRegisteredAction(action)) {
            return client.invokeAction(action, actionPayload, senderIdentity);
        }
        return null;
    }

    public boolean addChannelListener(ChannelListener listener) {
        return this.channelListeners.add(listener);
    }

    public boolean removeChannelListener(ChannelListener listener) {
        return this.channelListeners.remove(listener);
    }

    protected void fireChannelConnectEvent(String channelId, String uuid, String name, String channelName) {
        ConnectionEvent event = new ConnectionEvent(channelId, uuid, name, channelName);
        for (ChannelListener listener : this.channelListeners) {
            listener.onChannelConnect(event);
        }
    }

    protected void fireChannelDisconnectEvent(String channelId, String uuid, String name, String channelName) {
        ConnectionEvent event = new ConnectionEvent(channelId, uuid, name, channelName);
        for (ChannelListener listener : this.channelListeners) {
            listener.onChannelDisconnect(event);
        }
    }

    public void processConnection(String channelId, JSONObject payload) {
        JSONObject clientIdentity = payload.getJSONObject("clientIdentity");
        ChannelProvider provider = this.providerMap.get(channelId);
        provider.processConnection(clientIdentity, payload);
    }
}

