/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebStartInstaller {
    private static final Logger logger = LoggerFactory.getLogger((String)WebStartInstaller.class.getName());
    private static String desktopPath = "OpenfinDesktop";
    private static String javaDemoPath = "OpenfinDesktopJavaDemo";
    private static String versionProp = "WSDesktopVersion";
    private static String versionFile = "WSDesktopVersion.txt";

    public static void main(String[] args) throws URISyntaxException, ZipException, IOException {
        try {
            if (WebStartInstaller.checkNewVersion()) {
                WebStartInstaller.extractZip("desktop.zip", desktopPath);
                WebStartInstaller.extractZip("java-adapter.zip", javaDemoPath);
                WebStartInstaller.updateExistingVersion();
            }
            WebStartInstaller.runJavaDemo();
        }
        catch (Exception e) {
            logger.error("Exception in main", (Throwable)e);
        }
        System.exit(0);
    }

    private static boolean checkNewVersion() {
        boolean hasNewVersion = true;
        String desktopVersion = System.getProperty(versionProp);
        if (desktopVersion != null) {
            logger.debug("checking desktop version " + desktopVersion);
            String existingVersion = WebStartInstaller.getExistingVersion();
            if (existingVersion != null) {
                boolean bl = hasNewVersion = !desktopVersion.equals(existingVersion);
            }
        }
        if (hasNewVersion) {
            logger.debug("need new desktop version, clearing cached version ");
            WebStartInstaller.clearDirectory(desktopPath);
            WebStartInstaller.clearDirectory(javaDemoPath);
        }
        return hasNewVersion;
    }

    private static String getExistingVersion() {
        String version = null;
        try {
            File vfile = new File(desktopPath + File.separator + versionFile);
            if (vfile.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(vfile));
                version = reader.readLine();
                reader.close();
            }
        }
        catch (Exception e) {
            logger.debug("Exception in getExistingVersion", (Throwable)e);
        }
        logger.debug("found cached desktop version " + version);
        return version;
    }

    private static void updateExistingVersion() {
        String desktopVersion = System.getProperty(versionProp);
        if (desktopVersion != null) {
            try {
                File vfile = new File(desktopPath + File.separator + versionFile);
                BufferedWriter writer = new BufferedWriter(new FileWriter(vfile, false));
                writer.write(desktopVersion);
                writer.close();
            }
            catch (Exception e) {
                logger.debug("Exception in updateExistingVersion", (Throwable)e);
            }
            logger.debug("set existing desktop version " + desktopVersion);
        }
    }

    private static void clearDirectory(String directory) {
        try {
            logger.debug("deleting " + directory);
            File dir = new File(directory);
            if (dir.exists()) {
                boolean deleted = dir.delete();
                logger.debug("deleted " + directory + " result " + deleted);
            }
        }
        catch (Exception e) {
            logger.debug("Exception in clearDirectory", (Throwable)e);
        }
    }

    private static void extractZip(String zipName, String path) {
        try {
            logger.debug("loading resource " + zipName);
            InputStream in = WebStartInstaller.class.getClassLoader().getResourceAsStream(zipName);
            if (in != null) {
                ZipInputStream zipFile = new ZipInputStream(in);
                WebStartInstaller.decompressFile(zipFile, path);
                in.close();
            } else {
                logger.debug("resource desktop.zip missing ");
            }
        }
        catch (Exception e) {
            logger.error("Exception in extractZip", (Throwable)e);
        }
    }

    private static void decompressFile(ZipInputStream zipFileStream, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            logger.debug("creating dir " + destDirectory);
            destDir.mkdir();
        }
        ZipEntry entry = zipFileStream.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                File file = new File(filePath);
                WebStartInstaller.createDir(file.getParent());
                WebStartInstaller.extractFile(zipFileStream, filePath);
            } else {
                WebStartInstaller.createDir(filePath);
            }
            zipFileStream.closeEntry();
            entry = zipFileStream.getNextEntry();
        }
        zipFileStream.close();
    }

    private static void createDir(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            logger.debug("creating dir " + path);
            dir.mkdirs();
        }
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        logger.debug("extracting " + filePath);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[2048];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    private static void runDesktop() throws Exception {
        logger.debug("starting openfin.exe ");
        OutputStream stdin = null;
        InputStream stderr = null;
        InputStream stdout = null;
        Process process = Runtime.getRuntime().exec("cmd");
        stdin = process.getOutputStream();
        stderr = process.getErrorStream();
        stdout = process.getInputStream();
        String line = "cd /d " + desktopPath + "\n";
        stdin.write(line.getBytes());
        stdin.flush();
        line = "start openfin.exe \n";
        stdin.write(line.getBytes());
        stdin.flush();
        stdin.close();
        BufferedReader brCleanUp = new BufferedReader(new InputStreamReader(stdout));
        while ((line = brCleanUp.readLine()) != null) {
            logger.debug("[Stdout] " + line);
        }
        brCleanUp.close();
        brCleanUp = new BufferedReader(new InputStreamReader(stderr));
        while ((line = brCleanUp.readLine()) != null) {
            logger.info("[Stderr] " + line);
        }
        brCleanUp.close();
    }

    private static void runJavaDemo() throws Exception {
        logger.debug("starting java demo ");
        OutputStream stdin = null;
        InputStream stderr = null;
        InputStream stdout = null;
        Process process = Runtime.getRuntime().exec("cmd");
        stdin = process.getOutputStream();
        stderr = process.getErrorStream();
        stdout = process.getInputStream();
        String line = "cd /d " + javaDemoPath + "\n";
        logger.debug("cmd: " + line);
        stdin.write(line.getBytes());
        stdin.flush();
        line = "java -cp openfin-desktop-java-adapter.jar com.openfin.desktop.demo.OpenFinDesktopDemo .." + File.separator + desktopPath + " 9696 \n ";
        logger.debug("cmd: " + line);
        stdin.write(line.getBytes());
        stdin.flush();
        stdin.close();
        BufferedReader brCleanUp = new BufferedReader(new InputStreamReader(stdout));
        while ((line = brCleanUp.readLine()) != null) {
            logger.debug("[Stdout] " + line);
        }
        brCleanUp.close();
        brCleanUp = new BufferedReader(new InputStreamReader(stderr));
        while ((line = brCleanUp.readLine()) != null) {
            logger.info("[Stderr] " + line);
        }
        brCleanUp.close();
    }
}

