package com.openfin.desktop.net;

import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Make singleton of WebSocketClient
 *
 * Created by wche on 9/22/2016.
 */
class WebSocketClientFactory {
    private static Logger logger = LoggerFactory.getLogger(WebSocketClientFactory.class.getName());
    private static WebSocketClient client;

    static synchronized WebSocketClient getWebSocketClient() {
        if (client == null) {
            logger.debug("Creating WebSocketClient");
            client = new WebSocketClient();
            client.setDaemon(true);
            try {
                logger.debug("Starting WebSocketClient");
                client.start();
            } catch (Exception e) {
                logger.error("Error creating WebSocketClient", e);
            }
        }
        return client;
    }

    static synchronized void stopWebSocketClient() {
        if (client != null) {
            try {
                client.stop();
                client = null;
            } catch (Exception e) {
                logger.error("Error stopping WebSocketClient", e);
            }
        }
    }
}
