package com.openfin.desktop.channel;

import java.util.concurrent.ConcurrentHashMap;

import org.json.JSONObject;

import com.openfin.desktop.AckListener;

public class ChannelBase {

	protected Middleware defaultAction;
	protected Middleware onError;
	protected Middleware beforeAction;
	protected Middleware afterAction;
	protected ConcurrentHashMap<String, ChannelAction> channelActionMap;
	protected Channel channel;
	protected JSONObject providerIdentity;

	public ChannelBase(Channel channel, JSONObject providerIdentity) {
		this.channel = channel;
		this.providerIdentity = providerIdentity;
		this.channelActionMap = new ConcurrentHashMap<String, ChannelAction>();
	}

	public boolean register(String action, ChannelAction listener) {
		return this.channelActionMap.putIfAbsent(action, listener) == null;
	}

	public boolean remove(String action) {
		return this.channelActionMap.remove(action) != null;
	}

	public void setDefaultAction(Middleware middleware) {
		this.defaultAction = middleware;
	}

	public void setOnError(Middleware middleware) {
		this.onError = middleware;
	}

	public void setBeforeAction(Middleware middleware) {
		this.beforeAction = middleware;
	}

	public void setAfterAction(Middleware middleware) {
		this.afterAction = middleware;
	}

	public String getChannelName() {
		return this.providerIdentity.getString("channelName");
	}

	public String getUuid() {
		return this.providerIdentity.getString("uuid");
	}

	public String getChannelId() {
		return this.providerIdentity.getString("channelId");
	}

	public String getName() {
		return this.providerIdentity.has("name") ? this.providerIdentity.getString("name")
				: this.providerIdentity.getString("uuid");
	}

	public boolean hasRegisteredAction(String action) {
		return channelActionMap.containsKey(action);
	}

	public void dispatch(JSONObject destinationIdentity, String action, JSONObject actionPayload,
			AckListener ackListener) {
		this.channel.sendChannelMessage(action, destinationIdentity, this.providerIdentity, actionPayload, ackListener);
	}

	public JSONObject invokeAction(String action, JSONObject payload, JSONObject senderIdentity) {
		try {
			ChannelAction channelAction = this.channelActionMap.get(action);
			if (channelAction != null || this.defaultAction != null ) {
				if (this.beforeAction != null) {
					payload = this.beforeAction.invoke(action, payload, senderIdentity);
				}
				if (channelAction != null) {
					payload = channelAction.invoke(action, payload);
				}
				else {
					payload = this.defaultAction.invoke(action, payload, senderIdentity);
				}
				
				if (this.afterAction != null) {
					payload = this.afterAction.invoke(action, payload, senderIdentity);
				}
				return payload;
			}
			else {
				//error, throw exception?
				return null;
			}
		}
		catch(Exception ex) {
			if (this.onError != null) {
				this.onError.invoke(action, payload, senderIdentity);
			}
			ex.printStackTrace();
			return null;
		}
		finally {
		}
	}
}
