package com.openfin.desktop;

import org.json.JSONObject;

/**
 * Interface for processing external messages targeted at an application originating from HTTP/HTTPS.
 *
 * @author wche
 * @since 4/30/14
 */

public interface ExternalMessageListener {

    /**
     * Passes a message to the handler
     * @param resultHandler Sends the result status to the container
     * @param payload  JSONObject sent via HTTP/HTTPS
     */
    public void process(ExternalMessageResultHandler resultHandler, JSONObject payload);

}
