/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.win32;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)RegistryHelper.class.getName());
    private static final String RVM_INSTALL_DIR_REG_KEY = "Software\\OpenFin\\RVM\\Settings\\Deployment";
    private static final String RVM_INSTALL_DIR_GP_KEY = "Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\OpenFin\\RVM\\Settings\\Deployment";
    private static final String RVM_INSTALL_DIR_REG_VALUE_NAME = "rvmInstallDirectory";
    private static final String WIN_LOCAL_APP_DATA = "LOCALAPPDATA";

    public static String registryUserGetStringValue(String key, String valueName) {
        String value = null;
        try {
            logger.debug(String.format("Reading HKCU registry %s %s", key, valueName));
            value = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)key, (String)valueName);
        }
        catch (Exception ex) {
            logger.debug(String.format("Error reading registry %s %s", key, valueName));
        }
        return value;
    }

    public static String registryMachineGetStringValue(String key, String valueName) {
        String value = null;
        try {
            logger.debug(String.format("Reading HKLM registry %s %s", key, valueName));
            value = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key, (String)valueName);
        }
        catch (Exception ex) {
            logger.debug(String.format("Error reading registry %s %s", key, valueName));
        }
        return value;
    }

    public static String getRVMStringValue(String valueName) {
        String value = RegistryHelper.registryUserGetStringValue(RVM_INSTALL_DIR_GP_KEY, valueName);
        if (value == null) {
            value = RegistryHelper.registryMachineGetStringValue(RVM_INSTALL_DIR_GP_KEY, valueName);
        }
        if (value == null) {
            value = RegistryHelper.registryUserGetStringValue(RVM_INSTALL_DIR_REG_KEY, valueName);
        }
        if (value == null) {
            value = RegistryHelper.registryMachineGetStringValue(RVM_INSTALL_DIR_REG_KEY, valueName);
        }
        return value;
    }

    public static String getRVMInstallDirectory() {
        String value = RegistryHelper.getRVMStringValue(RVM_INSTALL_DIR_REG_VALUE_NAME);
        if (value == null) {
            logger.debug(String.format("%s missing from Registry.  Getting default ", RVM_INSTALL_DIR_REG_VALUE_NAME));
            String localAppData = System.getenv(WIN_LOCAL_APP_DATA);
            if (localAppData != null) {
                value = localAppData + File.separator + "OpenFin";
            } else {
                logger.debug(String.format("env variable %s not set ", WIN_LOCAL_APP_DATA));
            }
        }
        return value;
    }

    public static void main(String[] argv) {
        try {
            System.out.println(RegistryHelper.registryUserGetStringValue(RVM_INSTALL_DIR_REG_KEY, RVM_INSTALL_DIR_REG_VALUE_NAME));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

