/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel;

import com.openfin.desktop.AckListener;
import com.openfin.desktop.channel.Channel;
import com.openfin.desktop.channel.ChannelBase;
import com.openfin.desktop.channel.ChannelListener;
import com.openfin.desktop.channel.ConnectionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONObject;

public class ChannelProvider
extends ChannelBase {
    ArrayList<JSONObject> clients = new ArrayList();

    ChannelProvider(Channel messageChannelFactory, JSONObject providerIdentity) {
        super(messageChannelFactory, providerIdentity);
    }

    public void processConnection(final JSONObject clientIdentity, JSONObject connectionPayload) {
        this.clients.add(clientIdentity);
        this.channel.addChannelListener(new ChannelListener(){

            @Override
            public void onChannelConnect(ConnectionEvent connectionEvent) {
            }

            @Override
            public void onChannelDisconnect(ConnectionEvent connectionEvent) {
                if (connectionEvent.getName().equals(clientIdentity.getString("name")) && connectionEvent.getUuid().equals(clientIdentity.getString("uuid"))) {
                    ChannelProvider.this.processDisconnection(clientIdentity);
                }
            }
        });
    }

    public void processDisconnection(JSONObject clientIdentity) {
        String uuid = clientIdentity.getString("uuid");
        String name = clientIdentity.getString("name");
        Iterator<JSONObject> allClients = this.clients.iterator();
        while (allClients.hasNext()) {
            JSONObject client = allClients.next();
            if (!client.getString("uuid").equals(uuid) || !client.getString("name").equals(name)) continue;
            allClients.remove();
        }
    }

    public void publish(String action, JSONObject actionPayload, AckListener ackListener) {
        for (JSONObject client : this.clients) {
            this.dispatch(client, action, actionPayload, ackListener);
        }
    }
}

