/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel;

import com.openfin.desktop.AckListener;
import com.openfin.desktop.channel.Channel;
import com.openfin.desktop.channel.ChannelAction;
import com.openfin.desktop.channel.Middleware;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class ChannelBase {
    protected Middleware defaultAction;
    protected Middleware onError;
    protected Middleware beforeAction;
    protected Middleware afterAction;
    protected ConcurrentHashMap<String, ChannelAction> channelActionMap;
    protected Channel channel;
    protected JSONObject providerIdentity;

    public ChannelBase(Channel channel, JSONObject providerIdentity) {
        this.channel = channel;
        this.providerIdentity = providerIdentity;
        this.channelActionMap = new ConcurrentHashMap();
    }

    public boolean register(String action, ChannelAction listener) {
        return this.channelActionMap.putIfAbsent(action, listener) == null;
    }

    public boolean remove(String action) {
        return this.channelActionMap.remove(action) != null;
    }

    public void setDefaultAction(Middleware middleware) {
        this.defaultAction = middleware;
    }

    public void setOnError(Middleware middleware) {
        this.onError = middleware;
    }

    public void setBeforeAction(Middleware middleware) {
        this.beforeAction = middleware;
    }

    public void setAfterAction(Middleware middleware) {
        this.afterAction = middleware;
    }

    public String getChannelName() {
        return this.providerIdentity.getString("channelName");
    }

    public String getUuid() {
        return this.providerIdentity.getString("uuid");
    }

    public String getChannelId() {
        return this.providerIdentity.getString("channelId");
    }

    public String getName() {
        return this.providerIdentity.has("name") ? this.providerIdentity.getString("name") : this.providerIdentity.getString("uuid");
    }

    public boolean hasRegisteredAction(String action) {
        return this.channelActionMap.containsKey(action);
    }

    public void dispatch(JSONObject destinationIdentity, String action, JSONObject actionPayload, AckListener ackListener) {
        this.channel.sendChannelMessage(action, destinationIdentity, this.providerIdentity, actionPayload, ackListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject invokeAction(String action, JSONObject payload, JSONObject senderIdentity) {
        block8: {
            ChannelAction channelAction = this.channelActionMap.get(action);
            if (channelAction == null && this.defaultAction == null) break block8;
            if (this.beforeAction != null) {
                payload = this.beforeAction.invoke(action, payload, senderIdentity);
            }
            payload = channelAction != null ? channelAction.invoke(action, payload) : this.defaultAction.invoke(action, payload, senderIdentity);
            if (this.afterAction != null) {
                payload = this.afterAction.invoke(action, payload, senderIdentity);
            }
            JSONObject jSONObject = payload;
            return jSONObject;
        }
        try {
            JSONObject jSONObject = null;
            return jSONObject;
        }
        catch (Exception ex) {
            if (this.onError != null) {
                this.onError.invoke(action, payload, senderIdentity);
            }
            ex.printStackTrace();
            JSONObject jSONObject = null;
            return jSONObject;
        }
    }
}

