/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class RuntimeConfiguration
extends JSONObject {
    private int devToolsPort;
    private String runtimeVersion;
    private String runtimeFallbackVersion;
    private String securityRealm;
    private String additionalRuntimeArguments;
    private JSONObject startupApp;
    private List<JSONObject> appAssets;
    private String rdmURL;
    private String runtimeAssetURL;
    private String additionalRvmArguments;
    private String licenseKey;
    private Boolean nonPersistent;
    private Map<String, Object> configMap = new HashMap<String, Object>();
    private String launchRVMPath;
    private String manifestLocation;
    private String localManifestFileName;
    private String generatedManifestLocation;
    private boolean showInstallerUI = false;
    private int maxMessageSize = 0;
    private boolean useNamedPipePortDiscovery = false;
    private int runtimePort = -1;
    private List<JSONObject> services;

    public RuntimeConfiguration() {
        this.appAssets = new ArrayList<JSONObject>();
    }

    public void setDevToolsPort(int port) {
        this.devToolsPort = port;
    }

    public void setRuntimeVersion(String version) {
        this.runtimeVersion = version;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public String getRuntimeFallbackVersion() {
        return this.runtimeFallbackVersion;
    }

    public void setRuntimeFallbackVersion(String runtimeFallbackVersion) {
        this.runtimeFallbackVersion = runtimeFallbackVersion;
    }

    public void setSecurityRealm(String securityRealm) {
        this.securityRealm = securityRealm;
    }

    public String getSecurityRealm() {
        return this.securityRealm;
    }

    public void setAdditionalRuntimeArguments(String additionalRuntimeArguments) {
        this.additionalRuntimeArguments = additionalRuntimeArguments;
    }

    public void addAppAsset(JSONObject assetConfig) {
        this.appAssets.add(assetConfig);
    }

    public void setRdmURL(String rdmURL) {
        this.rdmURL = rdmURL;
    }

    public String getRdmURL() {
        return this.rdmURL;
    }

    public void setRuntimeAssetURL(String runtimeAssetURL) {
        this.runtimeAssetURL = runtimeAssetURL;
    }

    public String getRuntimeAssetURL() {
        return this.runtimeAssetURL;
    }

    public String getAdditionalRvmArguments() {
        return this.additionalRvmArguments;
    }

    public void setRvmVersion(String rvmVersion) {
        this.addConfigurationItem("rvmVersion", rvmVersion);
    }

    public void setShortCut(JSONObject shortCut) {
        this.addConfigurationItem("shortcut", shortCut);
    }

    public void setDialogSettings(JSONObject dialogSettings) {
        this.addConfigurationItem("dialogSettings", dialogSettings);
    }

    public void setSplashScreenImage(String splashScreenImage) {
        this.addConfigurationItem("splashScreenImage", splashScreenImage);
    }

    public void setSupportInformation(String supportInformation) {
        this.addConfigurationItem("supportInformation", supportInformation);
    }

    public void setAdditionalRvmArguments(String additionalRvmArguments) {
        this.additionalRvmArguments = additionalRvmArguments;
    }

    public void setStartupApp(JSONObject startupApp) {
        this.startupApp = startupApp;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    public boolean isNonPersistent() {
        return this.nonPersistent != null && this.nonPersistent != false;
    }

    public void setNonPersistent(Boolean nonPersistent) {
        this.nonPersistent = nonPersistent;
    }

    public boolean isUseNamedPipePortDiscovery() {
        return this.useNamedPipePortDiscovery;
    }

    public void setUseNamedPipePortDiscovery(boolean useNamedPipePortDiscovery) {
        this.useNamedPipePortDiscovery = useNamedPipePortDiscovery;
    }

    public void addConfigurationItem(String key, Object value) {
        this.configMap.put(key, value);
    }

    public void setLaunchRVMPath(String path) {
        this.launchRVMPath = path;
    }

    public String getLaunchRVMPath() {
        return this.launchRVMPath;
    }

    public String getManifestLocation() {
        return this.manifestLocation;
    }

    String getGeneratedManifestLocation() {
        return this.generatedManifestLocation;
    }

    void setGeneratedManifestLocation(String manifestLocation) {
        this.generatedManifestLocation = manifestLocation;
    }

    public String getLocalManifestFileName() {
        return this.localManifestFileName;
    }

    public void setLocalManifestFileName(String localManifestFileName) {
        this.localManifestFileName = localManifestFileName;
    }

    public boolean isShowInstallerUI() {
        return this.showInstallerUI;
    }

    public void setShowInstallerUI(boolean showInstallerUI) {
        this.showInstallerUI = showInstallerUI;
    }

    public void setManifestLocation(String manifestLocation) {
        this.manifestLocation = manifestLocation;
    }

    private void appendRuntimeOptions(JSONObject rootConfig) {
        JSONObject runtimeConfig = new JSONObject();
        StringBuffer arguments = new StringBuffer();
        if (this.securityRealm != null) {
            arguments.append(String.format(" --security-realm=%s ", this.securityRealm));
        }
        if (this.additionalRuntimeArguments != null) {
            arguments.append(String.format(" %s ", this.additionalRuntimeArguments));
        }
        runtimeConfig.put("arguments", (Object)arguments);
        runtimeConfig.put("version", (Object)this.runtimeVersion);
        if (this.runtimeFallbackVersion != null) {
            runtimeConfig.put("fallbackVersion", (Object)this.runtimeFallbackVersion);
        }
        rootConfig.put("runtime", (Object)runtimeConfig);
    }

    private void appendAppAssets(JSONObject rootConfig) {
        if (this.appAssets.size() > 0) {
            rootConfig.put("appAssets", this.appAssets);
        }
    }

    private void appendStartupConfig(JSONObject rootConfig) {
        if (this.startupApp != null) {
            rootConfig.put("startup_app", (Object)this.startupApp);
        }
    }

    private void appendAdditionalConfigItems(JSONObject rootConfig) {
        if (this.configMap.size() > 0) {
            for (String key : this.configMap.keySet()) {
                Object value = this.configMap.get(key);
                if (value instanceof Double) {
                    rootConfig.put(key, ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Integer) {
                    rootConfig.put(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Long) {
                    rootConfig.put(key, ((Long)value).longValue());
                    continue;
                }
                rootConfig.put(key, value);
            }
        }
    }

    private void appendRDMURL(JSONObject rootConfig) {
        if (this.rdmURL != null) {
            rootConfig.put("rdmUrl", (Object)this.rdmURL);
        }
    }

    private void appendRuntimeAssetsURL(JSONObject rootConfig) {
        if (this.runtimeAssetURL != null) {
            rootConfig.put("assetsUrl", (Object)this.runtimeAssetURL);
        }
    }

    private void appendLicensekey(JSONObject rootConfig) {
        if (this.licenseKey != null) {
            rootConfig.put("licenseKey", (Object)this.licenseKey);
        }
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    private void appendMaxMessageSize(JSONObject rootConfig) {
        if (this.maxMessageSize > 0) {
            // empty if block
        }
    }

    public int getRuntimePort() {
        return this.runtimePort;
    }

    public void setRuntimePort(int runtimePort) {
        this.runtimePort = runtimePort;
    }

    public void addService(String name, String manifestUrl) {
        if (this.services == null) {
            this.services = new ArrayList<JSONObject>();
        }
        JSONObject service = new JSONObject();
        service.put("name", (Object)name);
        if (manifestUrl != null) {
            service.put("manifestUrl", (Object)manifestUrl);
        }
        this.services.add(service);
    }

    private void appendServices(JSONObject rootConfig) {
        if (this.services != null) {
            rootConfig.put("services", this.services);
        }
    }

    public String generateRuntimeConfig() {
        JSONObject config = new JSONObject();
        if (this.devToolsPort > 0) {
            config.put("devtools_port", this.devToolsPort);
        }
        this.appendRuntimeOptions(config);
        this.appendRDMURL(config);
        this.appendRuntimeAssetsURL(config);
        this.appendAppAssets(config);
        this.appendStartupConfig(config);
        this.appendServices(config);
        this.appendAdditionalConfigItems(config);
        this.appendLicensekey(config);
        this.appendMaxMessageSize(config);
        return config.toString();
    }
}

