/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.AckListener;
import com.openfin.desktop.BusListener;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.DesktopException;
import com.openfin.desktop.SubscriptionListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterApplicationBus {
    private static final Logger logger = LoggerFactory.getLogger((String)InterApplicationBus.class.getName());
    private DesktopConnection desktopConnection;
    private Map<String, Map<String, List<BusListener>>> callbackMap = new ConcurrentHashMap<String, Map<String, List<BusListener>>>();
    private List<SubscriptionListener> subscribeListeners = new CopyOnWriteArrayList<SubscriptionListener>();

    public InterApplicationBus(DesktopConnection desktopConnection) {
        this.desktopConnection = desktopConnection;
    }

    public void publish(String topic, Object message) throws DesktopException {
        this.publish(topic, message, null);
    }

    public void publish(String topic, Object message, AckListener callback) throws DesktopException {
        JSONObject payload = new JSONObject();
        try {
            payload.put("topic", (Object)topic).put("message", message != null ? message : null);
        }
        catch (JSONException e) {
            logger.error("Error publishing message", (Throwable)e);
            throw new DesktopException((Exception)((Object)e));
        }
        this.desktopConnection.sendAction("publish-message", payload, callback, message != null ? message : this.desktopConnection);
    }

    public void send(String destinationUuid, String topic, Object message) throws DesktopException {
        this.send(destinationUuid, topic, message, null);
    }

    public void send(String destinationUuid, String topic, Object message, AckListener listener) throws DesktopException {
        JSONObject payload = new JSONObject();
        try {
            payload.put("destinationUuid", (Object)destinationUuid).put("topic", (Object)topic).put("message", message != null ? message : null);
        }
        catch (JSONException e) {
            logger.error("Error sending message", (Throwable)e);
            throw new DesktopException((Exception)((Object)e));
        }
        this.desktopConnection.sendAction("send-message", payload, listener, message != null ? message : this.desktopConnection);
    }

    public void subscribe(String sourceUuid, String topic, BusListener listener) throws DesktopException {
        this.subscribe(sourceUuid, topic, listener, null);
    }

    public void subscribe(String sourceUuid, String topic, BusListener listener, AckListener callback) throws DesktopException {
        List<BusListener> cbList;
        Map<String, List<BusListener>> cbByTopic = this.callbackMap.get(sourceUuid);
        if (cbByTopic == null) {
            cbByTopic = new ConcurrentHashMap<String, List<BusListener>>();
            this.callbackMap.put(sourceUuid, cbByTopic);
        }
        if ((cbList = cbByTopic.get(topic)) == null) {
            cbList = new CopyOnWriteArrayList<BusListener>();
            cbByTopic.put(topic, cbList);
        }
        cbList.add(listener);
        JSONObject payload = new JSONObject();
        try {
            payload.put("sourceUuid", (Object)sourceUuid).put("topic", (Object)topic);
        }
        catch (JSONException e) {
            logger.error("Error subscribing", (Throwable)e);
            throw new DesktopException((Exception)((Object)e));
        }
        this.desktopConnection.sendAction("subscribe", payload, callback, this);
    }

    public void unsubscribe(String sourceUuid, String topic, BusListener listener) throws DesktopException {
        this.unsubscribe(sourceUuid, topic, listener, null);
    }

    public void unsubscribe(String sourceUuid, String topic, BusListener listener, AckListener callback) throws DesktopException {
        List<BusListener> cbList;
        Map<String, List<BusListener>> cbMap = this.callbackMap.get(sourceUuid);
        if (cbMap != null && (cbList = cbMap.get(topic)) != null && cbList.remove(listener)) {
            JSONObject payload = new JSONObject();
            try {
                payload.put("sourceUuid", (Object)sourceUuid).put("topic", (Object)topic);
            }
            catch (JSONException e) {
                logger.error("Error unsubscribing", (Throwable)e);
                throw new DesktopException((Exception)((Object)e));
            }
            this.desktopConnection.sendAction("unsubscribe", payload, callback, this);
        }
    }

    void dispatchMessageToCallbacks(String sourceUuid, String topic, Object message) {
        if (this.callbackMap.containsKey("*")) {
            this.dispatchMessageToCallbacks(this.callbackMap.get("*"), sourceUuid, topic, message);
        }
        this.dispatchMessageToCallbacks(this.callbackMap.get(sourceUuid), sourceUuid, topic, message);
    }

    private void dispatchMessageToCallbacks(Map<String, List<BusListener>> cbByTopic, String sourceUuid, String topic, Object message) {
        if (cbByTopic != null) {
            this.dispatchMessageToCallbacks(cbByTopic.get(topic), sourceUuid, topic, message);
            this.dispatchMessageToCallbacks(cbByTopic.get("*"), sourceUuid, topic, message);
        }
    }

    private void dispatchMessageToCallbacks(List<BusListener> cbList, String sourceUuid, String topic, Object message) {
        if (cbList != null) {
            for (BusListener cb : cbList) {
                cb.onMessageReceived(sourceUuid, topic, message);
            }
        }
    }

    public void addSubscribeListener(SubscriptionListener listener) {
        this.subscribeListeners.add(listener);
    }

    public void removeSubscribeListener(SubscriptionListener listener) {
        this.subscribeListeners.remove(listener);
    }

    void dispatchToSubscribeListeners(String uuid, String topic) {
        for (SubscriptionListener listener : this.subscribeListeners) {
            listener.subscribed(uuid, topic);
        }
    }

    void dispatchToUnsubscribeListeners(String uuid, String topic) {
        for (SubscriptionListener listener : this.subscribeListeners) {
            listener.unsubscribed(uuid, topic);
        }
    }

    void reset() {
        logger.info("remove all listeners");
        this.subscribeListeners.clear();
        this.callbackMap.clear();
    }
}

