/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.WindowOptions;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationOptions {
    private static final Logger logger = LoggerFactory.getLogger((String)ApplicationOptions.class.getName());
    JSONObject options;
    WindowOptions mainWindowOptions;

    public ApplicationOptions(JSONObject options) {
        this.options = options;
    }

    public ApplicationOptions(String name, String uuid, String url) {
        this.options = new JSONObject();
        try {
            this.options.put("name", (Object)name);
            this.options.put("uuid", (Object)uuid);
            this.options.put("url", (Object)url);
        }
        catch (JSONException e) {
            logger.error("Error populating options", (Throwable)e);
        }
    }

    public String getName() {
        return this.getStringValue("name");
    }

    public String getUUID() {
        return this.getStringValue("uuid");
    }

    public String getURL() {
        return this.getStringValue("url");
    }

    public void setMainWindowOptions(WindowOptions options) {
        this.mainWindowOptions = options;
    }

    public WindowOptions getMainWindowOptions() {
        return this.mainWindowOptions;
    }

    public void setApplicationIcon(String applicationIcon) {
        try {
            this.options.put("applicationIcon", (Object)applicationIcon);
        }
        catch (JSONException e) {
            logger.error("Error setting applicationIcon");
        }
    }

    public String getApplicationIcon() {
        return this.getStringValue("applicationIcon");
    }

    public void setVersion(String version) {
        try {
            this.options.put("version", (Object)version);
        }
        catch (JSONException e) {
            logger.error("Error setting version");
        }
    }

    public String getVersion() {
        return this.getStringValue("version");
    }

    public JSONObject getJson() {
        try {
            this.options.put("mainWindowOptions", (Object)this.mainWindowOptions.getJson());
            return new JSONObject(this.options.toString());
        }
        catch (JSONException e) {
            logger.error("Error creating JSON object", (Throwable)e);
            return null;
        }
    }

    protected String getStringValue(String property) {
        String value = null;
        try {
            value = this.options.getString(property);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return value;
    }

    public ApplicationOptions put(String key, Object value) throws JSONException {
        this.options.put(key, value);
        return this;
    }
}

