package com.openfin.desktop.animation;

import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * A class representing a transition of a Window's opacity.
 * The Opacity property represents the resulting opacity of the window.
 * The value is clamped beween 0.0 and 1.0.  Default: 1.0
 * The Duration property represents the total time in milliseconds for the transition to complete.
 * @author wche
 * @since 2/11/14
 */
public class OpacityTransition extends AbstractAnimation {
    private final static Logger logger = LoggerFactory.getLogger(OpacityTransition.class.getName());

    /**
     * Constructor
     */
    public OpacityTransition() {
    }

    /**
     * Consturctor
     * @param opacity Value of opacity
     * @param duration Duration of the animation
     */
    public OpacityTransition(Double opacity, Integer duration) {
        this.setOpacity(opacity);
        this.setDuration(duration);
    }

    /**
     * Gets value of Opacity
     * @return Value of Opacity
     */
    public Double getOpacity() {
        Double d = null;
        try {
            d = this.jsonObject.getDouble("opacity");
        } catch (Exception e) {
            logger.error("Error getting opacity", e);
        }
        return d;
    }

    /**
     * Sets value of opacity
     * @param opacity New value of opacity
     */
    public void setOpacity(Double opacity) {
        try {
            this.jsonObject.put("opacity", opacity);
        } catch (Exception e) {
            logger.error("Error setting opacity", e);
        }
    }

    /**
     * Gets value of duration
     * @return Value of duration
     */
    public Integer getDuration() {
        Integer value = null;
        try {
            value = this.jsonObject.getInt("duration");
        } catch (Exception e) {
            logger.error("Error getting duration", e);
        }
        return value;
    }

    /**
     * Sets value of duration
     * @param duration Value of duration
     */
    public void setDuration(Integer duration) {
        try {
            this.jsonObject.put("duration", duration);
        } catch (Exception e) {
            logger.error("Error setting duration", e);
        }
    }

}
