/*
 * Decompiled with CFR 0.152.
 */
package de.roderick.weberknecht;

import de.roderick.weberknecht.WebSocketException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketHandshake {
    private String key1 = null;
    private String key2 = null;
    private byte[] key3 = null;
    private byte[] expectedServerResponse = null;
    private URI url = null;
    private String origin = null;
    private String protocol = null;

    public WebSocketHandshake(URI url, String protocol) {
        this.url = url;
        this.protocol = null;
        this.generateKeys();
    }

    public byte[] getHandshake() {
        String path = this.url.getPath();
        String host = this.url.getHost();
        this.origin = "http://" + host;
        String handshake = "GET " + path + " HTTP/1.1\r\n" + "Host: " + host + "\r\n" + "Connection: Upgrade\r\n" + "Sec-WebSocket-Key2: " + this.key2 + "\r\n";
        if (this.protocol != null) {
            handshake = handshake + "Sec-WebSocket-Protocol: " + this.protocol + "\r\n";
        }
        handshake = handshake + "Upgrade: WebSocket\r\nSec-WebSocket-Key1: " + this.key1 + "\r\n" + "Origin: " + this.origin + "\r\n" + "\r\n";
        byte[] handshakeBytes = new byte[handshake.getBytes().length + 8];
        System.arraycopy(handshake.getBytes(), 0, handshakeBytes, 0, handshake.getBytes().length);
        System.arraycopy(this.key3, 0, handshakeBytes, handshake.getBytes().length, 8);
        return handshakeBytes;
    }

    public void verifyServerResponse(byte[] bytes) throws WebSocketException {
        if (!Arrays.equals(bytes, this.expectedServerResponse)) {
            throw new WebSocketException("not a WebSocket Server");
        }
    }

    public void verifyServerStatusLine(String statusLine) throws WebSocketException {
        int statusCode = Integer.valueOf(statusLine.substring(9, 12));
        if (statusCode == 407) {
            throw new WebSocketException("connection failed: proxy authentication not supported");
        }
        if (statusCode == 404) {
            throw new WebSocketException("connection failed: 404 not found");
        }
        if (statusCode != 101) {
            throw new WebSocketException("connection failed: unknown status code " + statusCode);
        }
    }

    public void verifyServerHandshakeHeaders(HashMap<String, String> headers) throws WebSocketException {
        if (!headers.get("Upgrade").equals("WebSocket")) {
            throw new WebSocketException("connection failed: missing header field in server handshake: Upgrade");
        }
        if (!headers.get("Connection").equals("Upgrade")) {
            throw new WebSocketException("connection failed: missing header field in server handshake: Connection");
        }
        if (!headers.get("Sec-WebSocket-Origin").equals(this.origin)) {
            throw new WebSocketException("connection failed: missing header field in server handshake: Sec-WebSocket-Origin");
        }
    }

    private void generateKeys() {
        int spaces1 = this.rand(1, 12);
        int spaces2 = this.rand(1, 12);
        int max1 = Integer.MAX_VALUE / spaces1;
        int max2 = Integer.MAX_VALUE / spaces2;
        int number1 = this.rand(0, max1);
        int number2 = this.rand(0, max2);
        int product1 = number1 * spaces1;
        int product2 = number2 * spaces2;
        this.key1 = Integer.toString(product1);
        this.key2 = Integer.toString(product2);
        this.key1 = this.insertRandomCharacters(this.key1);
        this.key2 = this.insertRandomCharacters(this.key2);
        this.key1 = this.insertSpaces(this.key1, spaces1);
        this.key2 = this.insertSpaces(this.key2, spaces2);
        this.key3 = this.createRandomBytes();
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(number1);
        byte[] number1Array = buffer.array();
        buffer = ByteBuffer.allocate(4);
        buffer.putInt(number2);
        byte[] number2Array = buffer.array();
        byte[] challenge = new byte[16];
        System.arraycopy(number1Array, 0, challenge, 0, 4);
        System.arraycopy(number2Array, 0, challenge, 4, 4);
        System.arraycopy(this.key3, 0, challenge, 8, 8);
        this.expectedServerResponse = this.md5(challenge);
    }

    private String insertRandomCharacters(String key) {
        int count = this.rand(1, 12);
        char[] randomChars = new char[count];
        int randCount = 0;
        while (randCount < count) {
            int rand = (int)(Math.random() * 126.0 + 33.0);
            if ((33 >= rand || rand >= 47) && (58 >= rand || rand >= 126)) continue;
            randomChars[randCount] = (char)rand;
            ++randCount;
        }
        for (int i = 0; i < count; ++i) {
            int split = this.rand(0, key.length());
            String part1 = key.substring(0, split);
            String part2 = key.substring(split);
            key = part1 + randomChars[i] + part2;
        }
        return key;
    }

    private String insertSpaces(String key, int spaces) {
        for (int i = 0; i < spaces; ++i) {
            int split = this.rand(1, key.length() - 1);
            String part1 = key.substring(0, split);
            String part2 = key.substring(split);
            key = part1 + " " + part2;
        }
        return key;
    }

    private byte[] createRandomBytes() {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)this.rand(0, 255);
        }
        return bytes;
    }

    private byte[] md5(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private int rand(int min, int max) {
        int rand = (int)(Math.random() * (double)max + (double)min);
        return rand;
    }
}

