/*
 * Decompiled with CFR 0.152.
 */
package de.roderick.weberknecht;

import de.roderick.weberknecht.WebSocket;
import de.roderick.weberknecht.WebSocketEventHandler;
import de.roderick.weberknecht.WebSocketException;
import de.roderick.weberknecht.WebSocketHandshake;
import de.roderick.weberknecht.WebSocketReceiver;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnection
implements WebSocket {
    private static Logger logger = LoggerFactory.getLogger((String)WebSocketConnection.class.getName());
    private URI url = null;
    private WebSocketEventHandler eventHandler = null;
    private volatile boolean connected = false;
    private Socket socket = null;
    private InputStream input = null;
    private BufferedOutputStream output = null;
    private WebSocketReceiver receiver = null;
    private WebSocketHandshake handshake = null;

    public WebSocketConnection(URI url) throws WebSocketException {
        this(url, null);
    }

    public WebSocketConnection(URI url, String protocol) throws WebSocketException {
        this.url = url;
        this.handshake = new WebSocketHandshake(url, protocol);
    }

    public void setEventHandler(WebSocketEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public WebSocketEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void connect() throws WebSocketException {
        try {
            if (this.connected) {
                throw new WebSocketException("already connected");
            }
            this.socket = this.createSocket();
            this.input = this.socket.getInputStream();
            this.output = new BufferedOutputStream(this.socket.getOutputStream());
            this.output.write(this.handshake.getHandshake());
            this.output.flush();
            boolean handshakeComplete = false;
            boolean header = true;
            int len = 2000;
            byte[] buffer = new byte[len];
            int pos = 0;
            ArrayList<String> handshakeLines = new ArrayList<String>();
            byte[] serverResponse = new byte[16];
            while (!handshakeComplete) {
                int b = this.input.read();
                buffer[pos] = (byte)b;
                ++pos;
                if (!header) {
                    serverResponse[pos - 1] = (byte)b;
                    if (pos != 16) continue;
                    handshakeComplete = true;
                    continue;
                }
                if (buffer[pos - 1] != 10 || buffer[pos - 2] != 13) continue;
                String line = new String(buffer, "UTF-8");
                if (line.trim().equals("")) {
                    header = false;
                } else {
                    handshakeLines.add(line.trim());
                }
                buffer = new byte[len];
                pos = 0;
            }
            this.handshake.verifyServerStatusLine((String)handshakeLines.get(0));
            this.handshake.verifyServerResponse(serverResponse);
            handshakeLines.remove(0);
            HashMap<String, String> headers = new HashMap<String, String>();
            for (String line : handshakeLines) {
                String[] keyValue = line.split(": ", 2);
                headers.put(keyValue[0], keyValue[1]);
            }
            this.handshake.verifyServerHandshakeHeaders(headers);
            this.receiver = new WebSocketReceiver(this.input, this);
            this.receiver.start();
            this.connected = true;
            this.eventHandler.onOpen();
        }
        catch (WebSocketException wse) {
            throw wse;
        }
        catch (IOException ioe) {
            throw new WebSocketException("error while connecting: " + ioe.getMessage(), ioe);
        }
    }

    public synchronized void send(String data) throws WebSocketException {
        if (!this.connected) {
            throw new WebSocketException("error while sending text data: not connected");
        }
        try {
            this.output.write(0);
            this.output.write(data.getBytes("UTF-8"));
            this.output.write(255);
            this.output.flush();
        }
        catch (UnsupportedEncodingException uee) {
            throw new WebSocketException("error while sending text data: unsupported encoding", uee);
        }
        catch (IOException ioe) {
            throw new WebSocketException("error while sending text data", ioe);
        }
    }

    public void handleReceiverError() {
        try {
            if (this.connected) {
                this.close();
            }
        }
        catch (WebSocketException wse) {
            logger.debug("Error closing on error", (Object)wse.getMessage());
        }
    }

    public synchronized void close() throws WebSocketException {
        if (!this.connected) {
            return;
        }
        try {
            this.sendCloseHandshake();
            if (this.receiver.isRunning()) {
                this.receiver.stopit();
            }
            this.closeStreams();
        }
        finally {
            this.eventHandler.onClose();
        }
    }

    private synchronized void sendCloseHandshake() throws WebSocketException {
        if (!this.connected) {
            throw new WebSocketException("error while sending close handshake: not connected");
        }
        try {
            this.output.write(255);
            this.output.write(0);
            this.output.flush();
        }
        catch (IOException ioe) {
            throw new WebSocketException("error while sending close handshake", ioe);
        }
        this.connected = false;
    }

    private Socket createSocket() throws WebSocketException {
        String scheme = this.url.getScheme();
        String host = this.url.getHost();
        int port = this.url.getPort();
        Socket socket = null;
        if (scheme != null && scheme.equals("ws")) {
            if (port == -1) {
                port = 80;
            }
            try {
                socket = new Socket(host, port);
            }
            catch (UnknownHostException uhe) {
                throw new WebSocketException("unknown host: " + host, uhe);
            }
            catch (IOException ioe) {
                throw new WebSocketException("error while creating socket to " + this.url, ioe);
            }
        } else if (scheme != null && scheme.equals("wss")) {
            if (port == -1) {
                port = 443;
            }
            try {
                SocketFactory factory = SSLSocketFactory.getDefault();
                socket = factory.createSocket(host, port);
            }
            catch (UnknownHostException uhe) {
                throw new WebSocketException("unknown host: " + host, uhe);
            }
            catch (IOException ioe) {
                throw new WebSocketException("error while creating secure socket to " + this.url, ioe);
            }
        } else {
            throw new WebSocketException("unsupported protocol: " + scheme);
        }
        return socket;
    }

    private void closeStreams() throws WebSocketException {
        try {
            this.input.close();
            this.output.close();
            this.socket.close();
        }
        catch (IOException ioe) {
            throw new WebSocketException("error while closing websocket connection: ", ioe);
        }
    }
}

