/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.win32;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.ActionEvent;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.DesktopException;
import com.openfin.desktop.DesktopStateListener;
import com.openfin.desktop.DesktopUtils;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.Window;
import com.openfin.desktop.win32.WinMessageHelper;
import com.openfin.desktop.win32.WindowProcCallback;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalWindowObserver
implements DesktopStateListener {
    private static final Logger logger = LoggerFactory.getLogger((String)ExternalWindowObserver.class.getName());
    private String appUuid;
    private String name;
    private DesktopConnection desktopConnection;
    private WinDef.HWND hwnd;
    private String hwndHex;
    private boolean registered = false;
    private AckListener registerListener;
    private boolean frameDisabled;
    private boolean handlinguserDisabledFrame;
    private boolean ignoreNextChange;
    private int subscribedSystemEvents;
    public static final int WM_CAPTURECHANGED = 533;
    public static final int WM_DESTROY = 2;
    public static final int WM_ENTERSIZEMOVE = 561;
    public static final int WM_ERASEBKGND = 20;
    public static final int WM_EXITSIZEMOVE = 562;
    public static final int WM_KEYDOWN = 256;
    public static final int WM_KEYUP = 257;
    public static final int WM_KILLFOCUS = 8;
    public static final int WM_LBUTTONDOWN = 513;
    public static final int WM_LBUTTONUP = 514;
    public static final int WM_MOUSEMOVE = 512;
    public static final int WM_MOVE = 3;
    public static final int WM_MOVING = 534;
    public static final int WM_NCLBUTTONDBLCLK = 163;
    public static final int WM_NCLBUTTONUP = 162;
    public static final int WM_NOTIFY = 78;
    public static final int WM_SETFOCUS = 7;
    public static final int WM_SIZING = 532;
    public static final int WM_SYSCOMMAND = 274;
    public static final int WM_WINDOWPOSCHANGED = 71;
    public static final int WM_WINDOWPOSCHANGING = 70;
    public static final int WM_PAINT = 15;
    public static final int SC_CLOSE = 61536;
    public static final int SC_MAXIMIZE = 61488;
    public static final int SC_MINIMIZE = 61472;
    public static final int SC_RESTORE = 61728;
    public static final int SWP_HIDEWINDOW = 128;
    public static final int SWP_NOMOVE = 2;
    public static final int SWP_NOSIZE = 1;
    public static final int SWP_SHOWWINDOW = 64;
    private JSONObject blurPayload;
    private JSONObject captureChangedPayload;
    private JSONObject destroyedPayload;
    private JSONObject enterSizeMovePayload;
    private JSONObject exitSizeMovePayload;
    private JSONObject focusPayload;
    private JSONObject movePayload;
    private JSONObject movingPayload;
    private JSONObject ncDoubleClickPayload;
    private JSONObject posChangedPayload;
    private JSONObject posChangingPayload;
    private JSONObject sizingPayload;
    private JSONObject sysCommandPayload;
    private EventListener frameDisableListener = new EventListener(){

        public void eventReceived(ActionEvent actionEvent) {
            ExternalWindowObserver.this.onWindowFrameDisabled();
        }
    };
    private EventListener frameEnableListener = new EventListener(){

        public void eventReceived(ActionEvent actionEvent) {
            ExternalWindowObserver.this.onWindowFrameEnabled();
        }
    };

    public ExternalWindowObserver(int port, String parentAppUuid, String name, java.awt.Window window, AckListener listener) throws DesktopException {
        logger.debug("init for " + name);
        this.appUuid = parentAppUuid;
        this.name = name;
        this.desktopConnection = new DesktopConnection(UUID.randomUUID().toString(), null, port);
        this.hwnd = new WinDef.HWND();
        this.hwnd.setPointer(Native.getWindowPointer((java.awt.Window)window));
        this.hwndHex = Long.toHexString(Native.getWindowID((java.awt.Window)window));
        this.registerListener = listener;
        this.subscribedSystemEvents = 61808;
        this.desktopConnection.connect(this);
    }

    public String getAppUuid() {
        return this.appUuid;
    }

    public String getName() {
        return this.name;
    }

    private void cleanup() throws DesktopException {
        this.deregisterExternalWindow(null);
        WinMessageHelper.unhookWndProc(this.hwnd);
        this.desktopConnection.disconnect();
        logger.debug("cleanup");
    }

    public void dispose() throws DesktopException {
        this.cleanup();
    }

    private void onWindowFrameEnabled() {
        logger.debug("window frame enabled " + this.name);
        this.frameDisabled = false;
    }

    private void onWindowFrameDisabled() {
        logger.debug("window frame disabled " + this.name);
        this.frameDisabled = true;
    }

    private void registerExternalWindow(final AckListener callback) {
        logger.debug("registering " + this.name);
        JSONObject registerExternalWindowPayload = new JSONObject();
        registerExternalWindowPayload.put("topic", (Object)"application");
        registerExternalWindowPayload.put("uuid", (Object)this.appUuid);
        registerExternalWindowPayload.put("hwnd", (Object)this.hwndHex);
        registerExternalWindowPayload.put("name", (Object)this.name);
        AckListener subscribeToFrameSateChange = new AckListener(){

            public void onSuccess(final Ack ack) {
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            Window wnd = Window.wrap(ExternalWindowObserver.this.appUuid, ExternalWindowObserver.this.name, ExternalWindowObserver.this.desktopConnection);
                            DesktopUtils.addEventListener(wnd, "frame-disabled", ExternalWindowObserver.this.frameDisableListener);
                            DesktopUtils.addEventListener(wnd, "frame-enabled", ExternalWindowObserver.this.frameEnableListener);
                            DesktopUtils.successAck(callback, ack);
                        }
                        catch (Exception ex) {
                            logger.error("Error registering external window", (Throwable)ex);
                            DesktopUtils.errorAckOnException(callback, ExternalWindowObserver.this, ex);
                        }
                    }
                };
                thread.setName(ExternalWindowObserver.class.getName() + ".registerExternalWindow");
                thread.start();
            }

            public void onError(Ack ack) {
                logger.warn("Error registering external window " + ack.getReason());
                DesktopUtils.errorAck(callback, ack);
            }
        };
        this.desktopConnection.sendAction("register-external-window", registerExternalWindowPayload, subscribeToFrameSateChange, this);
    }

    private void deregisterExternalWindow(final AckListener callback) {
        if (this.registered) {
            logger.debug("deregistering " + this.name);
            this.registered = false;
            JSONObject deregisterExternalWindowPayload = new JSONObject();
            deregisterExternalWindowPayload.put("topic", (Object)"application");
            deregisterExternalWindowPayload.put("uuid", (Object)this.appUuid);
            deregisterExternalWindowPayload.put("hwnd", (Object)this.hwndHex);
            deregisterExternalWindowPayload.put("name", (Object)this.name);
            AckListener deSubscribeToFrameSateChange = new AckListener(){

                public void onSuccess(Ack ack) {
                    Window wnd = Window.wrap(ExternalWindowObserver.this.appUuid, ExternalWindowObserver.this.name, ExternalWindowObserver.this.desktopConnection);
                    wnd.removeEventListener("frame-disabled", ExternalWindowObserver.this.frameDisableListener, null);
                    wnd.removeEventListener("frame-enabled", ExternalWindowObserver.this.frameEnableListener, null);
                    DesktopUtils.successAck(callback, ack);
                }

                public void onError(Ack ack) {
                    logger.warn("Error deregistering external window " + ack.getReason());
                    DesktopUtils.errorAck(callback, ack);
                }
            };
            this.desktopConnection.sendAction("deregister-external-window", deregisterExternalWindowPayload, deSubscribeToFrameSateChange, this);
        }
    }

    private void sendExternalWindowEvent(JSONObject payload) {
        if (this.registered) {
            if (logger.isDebugEnabled()) {
                logger.debug(payload.toString());
            }
            this.desktopConnection.sendAction("external-window-action", payload, null, this);
        }
    }

    private void installMessageHandlers() {
        WindowProcCallback windowProcCallback = new WindowProcCallback(){

            public boolean callback(WinDef.HWND hwnd, int msg, WinDef.WPARAM wp, Pointer lp) {
                boolean handled = false;
                try {
                    switch (msg) {
                        case 533: {
                            ExternalWindowObserver.this.onCaptureChanged(hwnd, msg, wp, lp);
                            break;
                        }
                        case 2: {
                            ExternalWindowObserver.this.onWMDestroy(msg);
                            break;
                        }
                        case 561: {
                            ExternalWindowObserver.this.onEnterSizeMove(msg);
                            break;
                        }
                        case 562: {
                            ExternalWindowObserver.this.onExitSizeMove(msg);
                            break;
                        }
                        case 8: {
                            ExternalWindowObserver.this.onKillFocus(msg);
                            break;
                        }
                        case 3: {
                            ExternalWindowObserver.this.onMove(msg, wp, lp);
                            break;
                        }
                        case 534: {
                            handled = ExternalWindowObserver.this.onMoving(msg, wp, lp);
                            break;
                        }
                        case 163: {
                            ExternalWindowObserver.this.onNcDoubleClick(msg, wp, lp);
                            break;
                        }
                        case 7: {
                            ExternalWindowObserver.this.onSetFocus(msg);
                            break;
                        }
                        case 274: {
                            ExternalWindowObserver.this.onSysCommand(msg, wp);
                            break;
                        }
                        case 71: {
                            ExternalWindowObserver.this.onWindowPosChanged(msg, wp, lp);
                            break;
                        }
                        case 70: {
                            ExternalWindowObserver.this.onWindowPosChanging(msg, wp, lp);
                            break;
                        }
                        case 532: {
                            handled = ExternalWindowObserver.this.onSizing(msg, wp, lp);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Error processing callback", (Throwable)e);
                }
                return handled;
            }
        };
        try {
            WinMessageHelper.hookWndProc(this.hwnd, windowProcCallback);
            if (this.registerListener != null) {
                JSONObject msg = new JSONObject();
                msg.put("success", (Object)Boolean.TRUE);
                DesktopUtils.successAck(this.registerListener, new Ack(msg, this));
            }
        }
        catch (Throwable e) {
            JSONObject msg = new JSONObject();
            msg.put("success", (Object)Boolean.FALSE);
            DesktopUtils.errorAck(this.registerListener, new Ack(msg, this));
            logger.error("Error initializing", e);
        }
    }

    private void onCaptureChanged(WinDef.HWND hwnd, int msg, WinDef.WPARAM wp, Pointer lp) {
        logger.debug("onCaptureChanged");
        if (this.captureChangedPayload == null) {
            this.captureChangedPayload = this.createBaseWMJSONObject(msg);
        }
        WinDef.HWND h = new WinDef.HWND(lp);
        this.captureChangedPayload.put("lParam", Pointer.nativeValue((Pointer)lp));
        this.sendExternalWindowEvent(this.captureChangedPayload);
        if (this.handlinguserDisabledFrame && !hwnd.equals((Object)h)) {
            this.ignoreNextChange = true;
        }
    }

    private void onWMDestroy(int msg) {
        try {
            logger.debug("onWMDestroy");
            this.sendExternalWindowEvent(this.createBaseWMJSONObject(msg));
            this.cleanup();
        }
        catch (DesktopException e) {
            logger.error("Error onWMDestroy", (Throwable)e);
        }
    }

    private void onEnterSizeMove(int msg) {
        logger.debug("onEnterSizeMove");
        if (!this.handlinguserDisabledFrame && this.frameDisabled) {
            logger.debug("set handlinguserDisabledFrame true");
            this.handlinguserDisabledFrame = true;
        }
        if (this.enterSizeMovePayload == null) {
            this.enterSizeMovePayload = this.createBaseWMJSONObject(msg);
        }
        PointerInfo a = MouseInfo.getPointerInfo();
        Point b = a.getLocation();
        this.enterSizeMovePayload.put("mouseX", b.getX());
        this.enterSizeMovePayload.put("mouseY", b.getY());
        this.sendExternalWindowEvent(this.enterSizeMovePayload);
    }

    private void onExitSizeMove(int msg) {
        logger.debug("onExitSizeMove");
        if (this.handlinguserDisabledFrame) {
            logger.debug("set handlinguserDisabledFrame false");
            this.handlinguserDisabledFrame = false;
        }
        if (this.exitSizeMovePayload == null) {
            this.exitSizeMovePayload = this.createBaseWMJSONObject(msg);
        }
        PointerInfo a = MouseInfo.getPointerInfo();
        Point b = a.getLocation();
        this.exitSizeMovePayload.put("mouseX", b.getX());
        this.exitSizeMovePayload.put("mouseY", b.getY());
        this.sendExternalWindowEvent(this.exitSizeMovePayload);
    }

    private void onKillFocus(int msg) {
        logger.debug("onKillFocus");
        this.sendExternalWindowEvent(this.createBaseWMJSONObject(msg));
    }

    private void onMove(int msg, WinDef.WPARAM wp, Pointer lp) {
        logger.debug("onMove ");
        if (this.movePayload == null) {
            this.movePayload = this.createBaseWMJSONObject(msg);
        }
        WinDef.RECT bounds = new WinDef.RECT();
        User32.INSTANCE.GetWindowRect(this.hwnd, bounds);
        this.movePayload.put("x", bounds.left);
        this.movePayload.put("y", bounds.top);
        this.sendExternalWindowEvent(this.movePayload);
    }

    private boolean onMoving(int msg, WinDef.WPARAM wp, Pointer lp) {
        logger.debug("onMoving");
        boolean handled = false;
        if (this.movingPayload == null) {
            this.movingPayload = this.createBaseWMJSONObject(msg);
        }
        WINDOWRECT movingBounds = new WINDOWRECT(lp);
        this.movingPayload.put("left", movingBounds.left);
        this.movingPayload.put("top", movingBounds.top);
        this.movingPayload.put("right", movingBounds.right);
        this.movingPayload.put("bottom", movingBounds.bottom);
        PointerInfo a = MouseInfo.getPointerInfo();
        Point b = a.getLocation();
        this.movingPayload.put("mouseX", b.getX());
        this.movingPayload.put("mouseY", b.getY());
        if (this.handlinguserDisabledFrame) {
            logger.debug("handling disabled frame");
            WinDef.RECT currentBounds = new WinDef.RECT();
            User32.INSTANCE.GetWindowRect(this.hwnd, currentBounds);
            this.structureToPtr((Structure)currentBounds, lp);
            handled = true;
        }
        this.sendExternalWindowEvent(this.movingPayload);
        return handled;
    }

    private void onNcDoubleClick(int msg, WinDef.WPARAM wp, Pointer lp) {
        logger.debug("onNcDoubleClick");
        if (this.ncDoubleClickPayload == null) {
            this.ncDoubleClickPayload = this.createBaseWMJSONObject(msg);
        }
        this.ncDoubleClickPayload.put("wParam", wp.intValue());
        WinDef.POINT mouse = new WinDef.POINT();
        WinMessageHelper.customUser32.GetCursorPos(mouse);
        this.ncDoubleClickPayload.put("x", mouse.x);
        this.ncDoubleClickPayload.put("y", mouse.y);
        this.sendExternalWindowEvent(this.ncDoubleClickPayload);
    }

    private void onSetFocus(int msg) {
        logger.debug("onSetFocus");
        if (this.focusPayload == null) {
            this.focusPayload = this.createBaseWMJSONObject(msg);
        }
        this.sendExternalWindowEvent(this.focusPayload);
    }

    private void onSysCommand(int msg, WinDef.WPARAM wp) {
        logger.debug("onSysCommand");
        if (this.sysCommandPayload == null) {
            this.sysCommandPayload = this.createBaseWMJSONObject(msg);
        }
        if ((wp.intValue() & this.subscribedSystemEvents) > 0) {
            this.sysCommandPayload.put("wParam", wp.intValue());
            this.sendExternalWindowEvent(this.sysCommandPayload);
        }
    }

    private void onWindowPosChanged(int msg, WinDef.WPARAM wp, Pointer lp) {
        logger.debug("onWindowPosChanged ");
        if (this.posChangedPayload == null) {
            this.posChangedPayload = this.createBaseWMJSONObject(msg);
        }
        WINDOWPOS changeInfo = new WINDOWPOS(lp);
        this.posChangedPayload.put("hwnd", (Object)this.toHWNDHex(changeInfo.hwnd));
        if (changeInfo.hwndInsertAfter != null) {
            this.posChangedPayload.put("hwndInsertAfter", (Object)this.toHWNDHex(changeInfo.hwndInsertAfter));
        }
        this.posChangedPayload.put("x", changeInfo.x);
        this.posChangedPayload.put("y", changeInfo.y);
        this.posChangedPayload.put("cx", changeInfo.cx);
        this.posChangedPayload.put("cy", changeInfo.cy);
        this.posChangedPayload.put("flags", changeInfo.flags);
        this.sendExternalWindowEvent(this.posChangedPayload);
    }

    private void onWindowPosChanging(int msg, WinDef.WPARAM wp, Pointer lp) {
        boolean isSizing;
        logger.debug("onWindowPosChanging ");
        if (this.posChangingPayload == null) {
            this.posChangingPayload = this.createBaseWMJSONObject(msg);
        }
        WINDOWPOS changeInfo = new WINDOWPOS(lp);
        this.posChangingPayload.put("hwnd", (Object)this.toHWNDHex(changeInfo.hwnd));
        if (changeInfo.hwndInsertAfter != null) {
            this.posChangingPayload.put("hwndInsertAfter", (Object)this.toHWNDHex(changeInfo.hwndInsertAfter));
        }
        this.posChangingPayload.put("x", changeInfo.x);
        this.posChangingPayload.put("y", changeInfo.y);
        this.posChangingPayload.put("cx", changeInfo.cx);
        this.posChangingPayload.put("cy", changeInfo.cy);
        this.posChangingPayload.put("flags", changeInfo.flags);
        boolean isMoving = (changeInfo.flags & 2) == 0;
        boolean bl = isSizing = (changeInfo.flags & 1) == 0;
        if (isMoving || isSizing) {
            if (this.handlinguserDisabledFrame && this.ignoreNextChange) {
                logger.debug("prevent pos changing");
                changeInfo.flags |= 3;
                this.structureToPtr(changeInfo, lp);
            }
            this.ignoreNextChange = false;
        }
        this.sendExternalWindowEvent(this.posChangingPayload);
    }

    private boolean onSizing(int msg, WinDef.WPARAM wp, Pointer lp) {
        logger.debug("onSizing");
        boolean handled = false;
        if (this.sizingPayload == null) {
            this.sizingPayload = this.createBaseWMJSONObject(msg);
        }
        this.sizingPayload.put("wParam", wp.intValue());
        WINDOWRECT changeInfo = new WINDOWRECT(lp);
        this.sizingPayload.put("left", changeInfo.left);
        this.sizingPayload.put("top", changeInfo.top);
        this.sizingPayload.put("right", changeInfo.right);
        this.sizingPayload.put("bottom", changeInfo.bottom);
        WinDef.POINT mouse = new WinDef.POINT();
        WinMessageHelper.customUser32.GetCursorPos(mouse);
        this.sizingPayload.put("mouseX", mouse.x);
        this.sizingPayload.put("mouseY", mouse.y);
        if (this.handlinguserDisabledFrame) {
            WinDef.RECT currentBounds = new WinDef.RECT();
            User32.INSTANCE.GetWindowRect(this.hwnd, currentBounds);
            this.structureToPtr((Structure)currentBounds, lp);
            handled = true;
        }
        this.sendExternalWindowEvent(this.sizingPayload);
        return handled;
    }

    private JSONObject createBaseWMJSONObject(int msg) {
        JSONObject payload = new JSONObject();
        payload.put("uuid", (Object)this.appUuid);
        payload.put("name", (Object)this.name);
        payload.put("type", msg);
        return payload;
    }

    private String toHWNDHex(WinDef.HWND hwnd) {
        return Long.toHexString(Pointer.nativeValue((Pointer)hwnd.getPointer()));
    }

    private void structureToPtr(Structure struture, Pointer pointer) {
        byte[] buffer = new byte[struture.size()];
        struture.getPointer().read(0L, buffer, 0, struture.size());
        pointer.write(0L, buffer, 0, struture.size());
    }

    public void onReady() {
        this.registerExternalWindow(new AckListener(){

            public void onSuccess(Ack ack) {
                ExternalWindowObserver.this.registered = true;
                ExternalWindowObserver.this.installMessageHandlers();
            }

            public void onError(Ack ack) {
                DesktopUtils.errorAck(ExternalWindowObserver.this.registerListener, ack);
            }
        });
    }

    public void onClose() {
    }

    public void onError(String reason) {
    }

    public void onMessage(String message) {
    }

    public void onOutgoingMessage(String message) {
    }

    public static class WINDOWRECT
    extends Structure {
        public int left;
        public int top;
        public int right;
        public int bottom;

        public WINDOWRECT(Pointer memory) {
            super(memory);
            this.read();
        }

        protected List getFieldOrder() {
            return Arrays.asList("left", "top", "right", "bottom");
        }

        public Rectangle toRectangle() {
            return new Rectangle(this.left, this.top, this.right - this.left, this.bottom - this.top);
        }

        public String toString() {
            return "[(" + this.left + "," + this.top + ")(" + this.right + "," + this.bottom + ")]";
        }
    }

    public static class WINDOWPOS
    extends Structure {
        public WinDef.HWND hwnd;
        public WinDef.HWND hwndInsertAfter;
        public int x;
        public int y;
        public int cx;
        public int cy;
        public int flags;

        public WINDOWPOS(Pointer memory) {
            super(memory);
            this.read();
        }

        protected List getFieldOrder() {
            String[] aa = new String[]{"hwnd", "hwndInsertAfter", "x", "y", "cx", "cy", "flags"};
            return Arrays.asList(aa);
        }
    }
}

