/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.win32;

import com.openfin.desktop.ActionEvent;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.win32.WinMessageHelper;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesktopPortHandler
implements WinUser.WindowProc {
    private static final Logger logger = LoggerFactory.getLogger((String)DesktopPortHandler.class.getName());
    private static final String windowClassName = "OPENFIN_ADAPTER_WINDOW";
    private Map<String, WinMessageThread> callbacks = Collections.synchronizedMap(new HashMap());
    private static DesktopPortHandler instance;
    private WinDef.HMODULE hInst;
    private static int WM_COPYDATA;
    private static long MSGFLT_ALLOW;

    private DesktopPortHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerEventListener(EventListener listener, int timeout) {
        Class<DesktopPortHandler> clazz = DesktopPortHandler.class;
        synchronized (DesktopPortHandler.class) {
            if (instance == null) {
                instance = new DesktopPortHandler();
                instance.registerWindowClass();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            instance.createMesssageThread(listener, timeout);
            return;
        }
    }

    public static void removeEventListener(EventListener listener) {
        for (String key : DesktopPortHandler.instance.callbacks.keySet()) {
            WinMessageThread wthread = DesktopPortHandler.instance.callbacks.get(key);
            if (listener != wthread.getEventListener() || wthread.gethWnd() == null) continue;
            logger.debug("destroy message window " + wthread.gethWnd().getPointer().toString());
            User32.INSTANCE.PostMessage(wthread.gethWnd(), 16, null, null);
            instance.getLastError();
            wthread.timeoutThread.interrupt();
            DesktopPortHandler.instance.callbacks.remove(key);
            break;
        }
    }

    private void registerWindowClass() {
        logger.debug("Registering window class OPENFIN_ADAPTER_WINDOW");
        WString windowClass = new WString(windowClassName);
        this.hInst = Kernel32.INSTANCE.GetModuleHandle("");
        WinUser.WNDCLASSEX wClass = new WinUser.WNDCLASSEX();
        wClass.hInstance = this.hInst;
        wClass.lpfnWndProc = this;
        wClass.lpszClassName = windowClass;
        User32.INSTANCE.RegisterClassEx(wClass);
        this.getLastError();
    }

    public WinDef.LRESULT callback(WinDef.HWND hwnd, int uMsg, WinDef.WPARAM wparam, WinDef.LPARAM lparam) {
        logger.debug("uMsg " + uMsg);
        switch (uMsg) {
            case 74: {
                try {
                    COPYDATASTRUCT struct = new COPYDATASTRUCT(lparam.longValue());
                    String runtimeMsg = new String(struct.lpData.getByteArray(0L, struct.cbData), "UTF-16LE");
                    logger.debug("COPYDATA: " + runtimeMsg + " HWND " + hwnd.getPointer().toString());
                    JSONObject jsonObject = new JSONObject(runtimeMsg);
                    ActionEvent actionEvent = new ActionEvent(windowClassName, jsonObject, this);
                    this.fireEvent(hwnd, actionEvent);
                }
                catch (Exception e) {
                    logger.error("Error processing WM_COPYDATA", (Throwable)e);
                }
                return User32.INSTANCE.DefWindowProc(hwnd, uMsg, wparam, lparam);
            }
        }
        return User32.INSTANCE.DefWindowProc(hwnd, uMsg, wparam, lparam);
    }

    public int getLastError() {
        int rc = Kernel32.INSTANCE.GetLastError();
        if (rc != 0) {
            logger.debug("GetLastError: " + rc);
        }
        return rc;
    }

    private void createMesssageThread(EventListener listener, int timeout) {
        WinMessageThread winMessageThread = new WinMessageThread(listener, timeout);
        winMessageThread.start();
    }

    private void addEvenListener(WinDef.HWND hWnd, WinMessageThread winMessageThread) {
        this.callbacks.put(hWnd.getPointer().toString(), winMessageThread);
    }

    public void fireEvent(WinDef.HWND hwnd, ActionEvent actionEvent) {
        if (this.callbacks.get(hwnd.getPointer().toString()) != null) {
            this.callbacks.get(hwnd.getPointer().toString()).getEventListener().eventReceived(actionEvent);
        } else {
            logger.debug("HWND missing for fireEvent " + hwnd.getPointer().toString());
        }
    }

    static {
        WM_COPYDATA = 74;
        MSGFLT_ALLOW = 1L;
    }

    public static class COPYDATASTRUCT
    extends Structure {
        public BaseTSD.ULONG_PTR dwData;
        public int cbData;
        public Pointer lpData;

        public COPYDATASTRUCT() {
        }

        public COPYDATASTRUCT(long pointer) {
            this(new Pointer(pointer));
        }

        public COPYDATASTRUCT(Pointer memory) {
            super(memory);
            this.read();
        }

        protected final List getFieldOrder() {
            return Arrays.asList("dwData", "cbData", "lpData");
        }

        public static class ByReference
        extends COPYDATASTRUCT
        implements Structure.ByReference {
        }
    }

    protected class WinMessageThread
    extends Thread {
        private WinDef.HWND hWnd;
        private EventListener eventListener;
        private WString windowClass;
        private TimeoutThread timeoutThread;

        public WinMessageThread(EventListener listener, int timeout) {
            this.setDaemon(true);
            this.setName(DesktopPortHandler.class.getName() + ".WinMessageThread");
            this.eventListener = listener;
            this.timeoutThread = new TimeoutThread(listener, timeout);
            this.timeoutThread.start();
        }

        public void run() {
            this.windowClass = new WString(DesktopPortHandler.windowClassName);
            this.hWnd = User32.INSTANCE.CreateWindowEx(0, this.windowClass, "OpenFin Java hidden window used to catch the windows events ", 0, 0, 0, 0, 0, null, null, (WinDef.HINSTANCE)DesktopPortHandler.this.hInst, null);
            if (DesktopPortHandler.this.getLastError() == 0) {
                int returnCode;
                this.changeWindowFilter();
                logger.debug(Thread.currentThread().getName() + " started User32.INSTANCE.GetMessage " + this.hWnd.getPointer().toString());
                DesktopPortHandler.this.addEvenListener(this.hWnd, this);
                WinUser.MSG msg = new WinUser.MSG();
                while ((returnCode = User32.INSTANCE.GetMessage(msg, this.hWnd, 0, 0)) != 0) {
                    if (returnCode > 0) {
                        User32.INSTANCE.TranslateMessage(msg);
                        User32.INSTANCE.DispatchMessage(msg);
                        continue;
                    }
                    logger.debug(Thread.currentThread().getName() + " GetMessage return " + returnCode + ", stop GetMessage loop " + DesktopPortHandler.this.getLastError());
                    break;
                }
            } else {
                logger.warn("Error creating message window");
            }
            logger.debug(Thread.currentThread().getName() + " exiting ");
        }

        private void changeWindowFilter() {
            try {
                boolean filterResult = WinMessageHelper.customUser32.ChangeWindowMessageFilterEx(this.hWnd, WM_COPYDATA, new WinDef.DWORD(MSGFLT_ALLOW), null);
                if (filterResult) {
                    logger.debug("ChangeWindowMessageFilterEx returns " + filterResult);
                } else {
                    logger.warn("ChangeWindowMessageFilterEx returns " + DesktopPortHandler.this.getLastError());
                }
            }
            catch (UnsatisfiedLinkError linkError) {
                logger.warn("Error calling ChangeWindowMessageFilterEx", (Throwable)linkError);
            }
            catch (Exception ex) {
                logger.warn("Error calling ChangeWindowMessageFilterEx", (Throwable)ex);
            }
        }

        public WinDef.HWND gethWnd() {
            return this.hWnd;
        }

        public EventListener getEventListener() {
            return this.eventListener;
        }
    }

    protected class TimeoutThread
    extends Thread {
        private EventListener eventListener;
        private int timeout;
        private volatile boolean interrupted = false;

        public TimeoutThread(EventListener eventListener, int timeout) {
            this.eventListener = eventListener;
            this.timeout = timeout;
            this.setName(DesktopPortHandler.class.getName() + ".TimeoutThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            logger.debug("Starting timeout thread");
            EventListener eventListener = this.eventListener;
            synchronized (eventListener) {
                try {
                    this.eventListener.wait(this.timeout * 1000);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (!this.interrupted) {
                JSONObject jsonObject = new JSONObject();
                ActionEvent actionEvent = new ActionEvent("TIMEOUT", jsonObject, this);
                this.eventListener.eventReceived(actionEvent);
            }
            logger.debug("exiting");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interrupt() {
            logger.debug("Interrupting timeout thread");
            this.interrupted = true;
            EventListener eventListener = this.eventListener;
            synchronized (eventListener) {
                this.eventListener.notifyAll();
            }
        }
    }
}

