/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowOptions {
    private static final Logger logger = LoggerFactory.getLogger((String)WindowOptions.class.getName());
    JSONObject options;
    private int resizeRegionBottomRightCorner = 4;
    private int resizeRegionSize = 2;

    public WindowOptions() {
        this.options = new JSONObject();
    }

    public WindowOptions(String name, String url) {
        this();
        this.setName(name);
        this.setUrl(url);
    }

    public WindowOptions(JSONObject options) {
        this.options = options;
    }

    public void setShowTaskbarIcon(boolean showTaskbarIcon) {
        try {
            this.options.put("showTaskbarIcon", showTaskbarIcon);
        }
        catch (JSONException e) {
            logger.error("Error setting showTaskbarIcon", (Throwable)e);
        }
    }

    public String getName() {
        return this.getStringValue("name");
    }

    public void setName(String name) {
        try {
            this.options.put("name", (Object)name);
        }
        catch (JSONException e) {
            logger.error("Error setting name", (Throwable)e);
        }
    }

    public String getUrl() {
        return this.getStringValue("url");
    }

    public void setUrl(String url) {
        try {
            this.options.put("url", (Object)url);
        }
        catch (JSONException e) {
            logger.error("Error setting URL", (Throwable)e);
        }
    }

    public boolean getShowTaskbarIcon() {
        return this.getBooleanValue("showTaskbarIcon");
    }

    public void setDefaultWidth(int defaultWidth) {
        try {
            this.options.put("defaultWidth", defaultWidth);
        }
        catch (JSONException e) {
            logger.error("Error setting default width", (Throwable)e);
        }
    }

    public int getDefaultWidth() {
        return this.getIntegerValue("defaultWidth");
    }

    public void setDefaultHeight(int defaultHeight) {
        try {
            this.options.put("defaultHeight", defaultHeight);
        }
        catch (JSONException e) {
            logger.error("Error setting default height", (Throwable)e);
        }
    }

    public int getDefaultHeight() {
        return this.getIntegerValue("defaultHeight");
    }

    public void setDefaultTop(int defaultTop) {
        try {
            this.options.put("defaultTop", defaultTop);
        }
        catch (JSONException e) {
            logger.error("Error setting top", (Throwable)e);
        }
    }

    public int getDefaultTop() {
        return this.getIntegerValue("defaultTop");
    }

    public void setDefaultLeft(int defaultLeft) {
        try {
            this.options.put("defaultLeft", defaultLeft);
        }
        catch (JSONException e) {
            logger.error("Error setting left", (Throwable)e);
        }
    }

    public int getDefaultLeft() {
        return this.getIntegerValue("defaultLeft");
    }

    public void setFrame(boolean frame) {
        try {
            this.options.put("frame", frame);
        }
        catch (JSONException e) {
            logger.error("Error setting frame", (Throwable)e);
        }
    }

    public boolean getFrame() {
        return this.getBooleanValue("frame");
    }

    public void setResizable(boolean resizable) {
        try {
            this.options.put("resizable", resizable);
        }
        catch (JSONException e) {
            logger.error("Error setting resizable", (Throwable)e);
        }
    }

    public boolean getResizable() {
        return this.getBooleanValue("resizable");
    }

    public void setAutoShow(boolean autoShow) {
        try {
            this.options.put("autoShow", autoShow);
        }
        catch (JSONException e) {
            logger.error("Error setting autoShow", (Throwable)e);
        }
    }

    public boolean getAutoShow() {
        return this.getBooleanValue("autoShow");
    }

    public void setState(String state) {
        try {
            this.options.put("state", (Object)state);
        }
        catch (JSONException e) {
            logger.error("Error setting state", (Throwable)e);
        }
    }

    public String getState() {
        return this.getStringValue("state");
    }

    public void setOpacity(double opacity) {
        try {
            this.options.put("opacity", opacity);
        }
        catch (JSONException e) {
            logger.error("Error setting opacity", (Throwable)e);
        }
    }

    public double getOpacity() {
        return this.getDoubleValue("opacity");
    }

    public void setCornerRounding(int width, int height) {
        try {
            this.options.put("cornerRounding", (Object)new JSONObject().put("width", width).put("height", height));
        }
        catch (JSONException e) {
            logger.error("Error setting cornerRounding", (Throwable)e);
        }
    }

    public int getCornerRoundingHeight() {
        int height = 0;
        JSONObject jsonObject = this.getJsonValue("cornerRounding");
        if (jsonObject != null && jsonObject.has("height")) {
            height = jsonObject.getInt("height");
        }
        return height;
    }

    public int getCornerRoundingWidth() {
        int width = 0;
        JSONObject jsonObject = this.getJsonValue("cornerRounding");
        if (jsonObject != null && jsonObject.has("width")) {
            width = jsonObject.getInt("width");
        }
        return width;
    }

    public void setMinWidth(int minWidth) {
        try {
            this.options.put("minWidth", minWidth);
        }
        catch (JSONException e) {
            logger.error("Error setting minWidth", (Throwable)e);
        }
    }

    public int getMinWidth() {
        return this.getIntegerValue("minWidth");
    }

    public void setMaxWidth(int maxWidth) {
        try {
            this.options.put("maxWidth", maxWidth);
        }
        catch (JSONException e) {
            logger.error("Error setting maxWidth", (Throwable)e);
        }
    }

    public int getMaxWidth() {
        return this.getIntegerValue("maxWidth");
    }

    public void setMinHeight(int minHeight) {
        try {
            this.options.put("minHeight", minHeight);
        }
        catch (JSONException e) {
            logger.error("Error setting minHeight", (Throwable)e);
        }
    }

    public int getMinHeight() {
        return this.getIntegerValue("minHeight");
    }

    public void setMaxHeight(int maxHeight) {
        try {
            this.options.put("maxHeight", maxHeight);
        }
        catch (JSONException e) {
            logger.error("Error setting maxHeight", (Throwable)e);
        }
    }

    public int getMaxHeight() {
        return this.getIntegerValue("maxHeight");
    }

    public void setSaveWindowState(boolean saveWindowState) {
        try {
            this.options.put("saveWindowState", saveWindowState);
        }
        catch (JSONException e) {
            logger.error("Error setting sateWindowState", (Throwable)e);
        }
    }

    public boolean getSaveWindowState() {
        return this.getBooleanValue("saveWindowState", true);
    }

    public void setMinimizable(boolean maximizable) {
        try {
            this.options.put("minimizable", maximizable);
        }
        catch (JSONException e) {
            logger.error("Error setting minimizable", (Throwable)e);
        }
    }

    public boolean getMinimizable() {
        return this.getBooleanValue("minimizable");
    }

    public void setMaximizable(boolean maximizable) {
        try {
            this.options.put("maximizable", maximizable);
        }
        catch (JSONException e) {
            logger.error("Error setting maximizable", (Throwable)e);
        }
    }

    public boolean getMaximizable() {
        return this.getBooleanValue("maximizable");
    }

    public void setHideOnClose(boolean hideOnClose) {
        try {
            this.options.put("hideOnClose", hideOnClose);
        }
        catch (JSONException e) {
            logger.error("Error setting hideOnClose", (Throwable)e);
        }
    }

    public boolean getHideOnClose() {
        return this.getBooleanValue("hideOnClose");
    }

    public void setContextMenu(boolean contextMenu) {
        try {
            this.options.put("contextMenu", contextMenu);
        }
        catch (JSONException e) {
            logger.error("Error setting contextMenu", (Throwable)e);
        }
    }

    public boolean getContextMenu() {
        return this.getBooleanValue("contextMenu");
    }

    public void setTaskbarIcon(String taskbarIcon) {
        try {
            this.options.put("taskbarIcon", (Object)taskbarIcon);
        }
        catch (JSONException e) {
            logger.error("Error setting taskbarIcon", (Throwable)e);
        }
    }

    public String getTaskbarIcon() {
        return this.getStringValue("taskbarIcon");
    }

    public void setResizeRegionBottomRightCorner(int resizeRegionBottomRightCorner) {
        try {
            this.resizeRegionBottomRightCorner = resizeRegionBottomRightCorner;
            this.options.put("resizeRegion", (Object)new JSONObject().put("bottomRightCorner", this.resizeRegionBottomRightCorner).put("size", this.resizeRegionSize));
        }
        catch (JSONException e) {
            logger.error("Error setting resizeRegionBottomRightCorner", (Throwable)e);
        }
    }

    public int getResizeRegionBottomRightCorner() {
        int value = -1;
        JSONObject jsonObject = this.getJsonValue("resizeRegion");
        if (jsonObject != null && jsonObject.has("bottomRightCorner")) {
            value = this.getIntegerValue("bottomRightCorner");
        }
        return value;
    }

    public void setResizeRegionSize(int resizeRegionSize) {
        try {
            this.resizeRegionSize = resizeRegionSize;
            this.options.put("resizeRegion", (Object)new JSONObject().put("bottomRightCorner", this.resizeRegionBottomRightCorner).put("size", this.resizeRegionSize));
        }
        catch (JSONException e) {
            logger.error("Error setting resizeRegionSize", (Throwable)e);
        }
    }

    public int getResizeRegionSize() {
        int value = -1;
        JSONObject jsonObject = this.getJsonValue("resizeRegion");
        if (jsonObject != null && jsonObject.has("size")) {
            value = this.getIntegerValue("size");
        }
        return value;
    }

    public void setDefaultCentered(boolean defaultCentered) {
        try {
            this.options.put("defaultCentered", defaultCentered);
        }
        catch (JSONException e) {
            logger.error("Error setting defaultCentered", (Throwable)e);
        }
    }

    public boolean getDefaultCentered() {
        return this.getBooleanValue("defaultCentered");
    }

    public JSONObject toJsonObject() {
        return this.options;
    }

    protected JSONObject getJson() {
        try {
            return new JSONObject(this.options.toString());
        }
        catch (JSONException e) {
            logger.error("Error toJsonObject", (Throwable)e);
            return null;
        }
    }

    protected String getStringValue(String property) {
        String value = null;
        try {
            value = this.options.getString(property);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return value;
    }

    protected int getIntegerValue(String property) {
        int value = 0;
        try {
            value = this.options.getInt(property);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return value;
    }

    protected double getDoubleValue(String property) {
        double value = 0.0;
        try {
            value = this.options.getDouble(property);
        }
        catch (JSONException e) {
            // empty catch block
        }
        return value;
    }

    protected boolean getBooleanValue(String property) {
        return this.getBooleanValue(property, false);
    }

    protected boolean getBooleanValue(String property, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            value = this.options.getBoolean(property);
        }
        catch (JSONException e) {
            // empty catch block
        }
        return value;
    }

    protected JSONObject getJsonValue(String property) {
        JSONObject value = null;
        try {
            value = this.options.getJSONObject(property);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return value;
    }
}

