/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.Ack;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.JsonUtils;
import com.openfin.desktop.Window;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowGroupChangeEvent {
    private String memberOf;
    private String name;
    private String reason;
    private List<Window> sourceGroup;
    private String sourceWindowAppUuid;
    private String sourceWindowName;
    private List<Window> targetGroup;
    private String targetWindowAppUuid;
    private String targetWindowName;
    private String uuid;
    private DesktopConnection desktopConnection;

    public WindowGroupChangeEvent(Ack payload, DesktopConnection desktopConnection) throws JSONException {
        this.desktopConnection = desktopConnection;
        JSONObject data = payload != null && payload.getJsonObject() != null ? payload.getJsonObject() : new JSONObject();
        this.memberOf = JsonUtils.getStringValue(data, "memberOf", "nothing");
        this.name = JsonUtils.getStringValue(data, "name", "");
        this.reason = JsonUtils.getStringValue(data, "reason", "");
        this.sourceWindowAppUuid = JsonUtils.getStringValue(data, "sourceWindowAppUuid", "");
        this.sourceWindowName = JsonUtils.getStringValue(data, "sourceWindowName", "");
        this.targetWindowAppUuid = JsonUtils.getStringValue(data, "targetWindowAppUuid", "");
        this.targetWindowName = JsonUtils.getStringValue(data, "targetWindowName", "");
        this.uuid = JsonUtils.getStringValue(data, "uuid", "");
        this.sourceGroup = new ArrayList<Window>();
        JSONArray sourceGroupWindows = JsonUtils.getJsonArray(data, "sourceGroup", null);
        if (sourceGroupWindows != null) {
            for (int i = 0; i < sourceGroupWindows.length(); ++i) {
                JSONObject entry = sourceGroupWindows.getJSONObject(i);
                this.sourceGroup.add(Window.wrap(JsonUtils.getStringValue(entry, "appUuid", ""), JsonUtils.getStringValue(entry, "windowName", ""), desktopConnection));
            }
        }
        this.targetGroup = new ArrayList<Window>();
        JSONArray targetGroupWindows = JsonUtils.getJsonArray(data, "targetGroup", null);
        if (targetGroupWindows != null) {
            for (int i = 0; i < sourceGroupWindows.length(); ++i) {
                JSONObject entry = sourceGroupWindows.getJSONObject(i);
                this.targetGroup.add(Window.wrap(JsonUtils.getStringValue(entry, "appUuid", ""), JsonUtils.getStringValue(entry, "windowName", ""), desktopConnection));
            }
        }
    }

    public String getMemberOf() {
        return this.memberOf;
    }

    public String getName() {
        return this.name;
    }

    public String getReason() {
        return this.reason;
    }

    public List<Window> getSourceGroup() {
        return this.sourceGroup;
    }

    public String getSourceWindowAppUuid() {
        return this.sourceWindowAppUuid;
    }

    public String getSourceWindowName() {
        return this.sourceWindowName;
    }

    public List<Window> getTargetGroup() {
        return this.targetGroup;
    }

    public String getTargetWindowAppUuid() {
        return this.targetWindowAppUuid;
    }

    public String getTargetWindowName() {
        return this.targetWindowName;
    }

    public String getUuid() {
        return this.uuid;
    }
}

