/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.Application;
import com.openfin.desktop.AsyncCallback;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.DesktopException;
import com.openfin.desktop.DesktopUtils;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.JsonUtils;
import com.openfin.desktop.WindowBounds;
import com.openfin.desktop.WindowOptions;
import com.openfin.desktop.animation.AnimationOptions;
import com.openfin.desktop.animation.AnimationTransitions;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Window {
    private static Logger logger = LoggerFactory.getLogger((String)Window.class.getName());
    private DesktopConnection connection;
    private JSONObject noParamPayload;
    private JSONObject resizeToPayload;
    private JSONObject resizeByPayload;
    private JSONObject moveToPayload;
    private JSONObject moveByPayload;
    private String uuid;
    private String name;

    private Window(String applicationUuid, String name, DesktopConnection connection) {
        this.connection = connection;
        this.initialize(applicationUuid, name);
    }

    protected Window(Application application) {
        this.connection = application.getConnection();
        this.initialize(application.getUuid(), application.getUuid());
    }

    private void initialize(String uuid, String name) {
        this.uuid = uuid;
        this.name = name;
        this.noParamPayload = new JSONObject();
        this.resizeToPayload = new JSONObject();
        this.resizeByPayload = new JSONObject();
        this.moveToPayload = new JSONObject();
        this.moveByPayload = new JSONObject();
        try {
            this.noParamPayload.put("uuid", (Object)uuid);
            this.resizeToPayload.put("uuid", (Object)uuid);
            this.resizeByPayload.put("uuid", (Object)uuid);
            this.moveToPayload.put("uuid", (Object)uuid);
            this.moveByPayload.put("uuid", (Object)uuid);
            this.noParamPayload.put("name", (Object)name);
            this.resizeToPayload.put("name", (Object)name);
            this.resizeByPayload.put("name", (Object)name);
            this.moveToPayload.put("name", (Object)name);
            this.moveByPayload.put("name", (Object)name);
        }
        catch (JSONException e) {
            logger.error("Error initializing", (Throwable)e);
        }
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public Application getParentApplication() {
        return Application.wrap(this.getUuid(), this.connection);
    }

    public Window getParentWindow() {
        return this.getParentApplication().getWindow();
    }

    public void getSnapshot(AckListener callback) {
        this.connection.sendAction("get-window-snapshot", new JSONObject(), callback, this);
    }

    public void show() throws DesktopException {
        this.connection.sendAction("show-window", this.noParamPayload);
    }

    public void show(AckListener listener) {
        this.connection.sendAction("show-window", this.noParamPayload, listener, this);
    }

    public void hide() throws DesktopException {
        this.connection.sendAction("hide-window", this.noParamPayload);
    }

    public void hide(AckListener listener) {
        this.connection.sendAction("hide-window", this.noParamPayload, listener, this);
    }

    public void close() throws DesktopException {
        this.connection.sendAction("close-window", this.noParamPayload);
    }

    public void close(AckListener listener) {
        this.connection.sendAction("close-window", this.noParamPayload, listener, this);
    }

    public void minimize() throws DesktopException {
        this.connection.sendAction("minimize-window", this.noParamPayload);
    }

    public void minimize(AckListener listener) {
        this.connection.sendAction("minimize-window", this.noParamPayload, listener, this);
    }

    public void maximize() throws DesktopException {
        this.connection.sendAction("maximize-window", this.noParamPayload);
    }

    public void maximize(AckListener listener) {
        this.connection.sendAction("maximize-window", this.noParamPayload, listener, this);
    }

    public void restore() throws DesktopException {
        this.connection.sendAction("restore-window", this.noParamPayload);
    }

    public void restore(AckListener listener) {
        this.connection.sendAction("restore-window", this.noParamPayload, listener, this);
    }

    public void focus() throws DesktopException {
        this.connection.sendAction("focus-window", this.noParamPayload);
    }

    public void focus(AckListener listener) {
        this.connection.sendAction("focus-window", this.noParamPayload, listener, this);
    }

    public void blur() throws DesktopException {
        this.connection.sendAction("blur-window", this.noParamPayload);
    }

    public void blur(AckListener listener) {
        this.connection.sendAction("blur-window", this.noParamPayload, listener, this);
    }

    public void flash(AckListener callback) {
        this.connection.sendAction("flash-window", new JSONObject(), callback, this);
    }

    public void stopFlashing(AckListener callback) {
        this.connection.sendAction("stop-flash-window", new JSONObject(), callback, this);
    }

    public void showAt(int left, int top, boolean toggle) throws DesktopException {
        try {
            this.connection.sendAction("show-at-window", this.moveToPayload.put("left", left).put("top", top).put("toggle", toggle));
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void showAt(int left, int top, boolean toggle, AckListener listener) throws DesktopException {
        try {
            this.connection.sendAction("show-at-window", this.moveToPayload.put("left", left).put("top", top).put("toggle", toggle), listener, this);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void moveTo(int left, int top) throws DesktopException {
        try {
            this.moveToPayload.put("left", left);
            this.moveToPayload.put("top", top);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
        this.connection.sendAction("move-window", this.moveToPayload);
    }

    public void moveTo(int left, int top, AckListener listener) throws DesktopException {
        try {
            this.moveToPayload.put("left", left);
            this.moveToPayload.put("top", top);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
        this.connection.sendAction("move-window", this.moveToPayload, listener, this);
    }

    public void moveBy(int deltaLeft, int deltaTop) throws DesktopException {
        this.moveBy(deltaLeft, deltaTop, null);
    }

    public void moveBy(int deltaLeft, int deltaTop, AckListener listener) throws DesktopException {
        try {
            this.moveByPayload.put("deltaLeft", deltaLeft);
            this.moveByPayload.put("deltaTop", deltaTop);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
        this.connection.sendAction("move-window-by", this.moveByPayload, listener, this);
    }

    public void resizeTo(int width, int height, String anchor) throws DesktopException {
        try {
            this.resizeToPayload.put("height", height);
            this.resizeToPayload.put("width", width);
            this.resizeToPayload.put("anchor", (Object)anchor);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
        this.connection.sendAction("resize-window", this.resizeToPayload);
    }

    public void resizeTo(int width, int height, String anchor, AckListener listener) throws DesktopException {
        try {
            this.resizeToPayload.put("height", height);
            this.resizeToPayload.put("width", width);
            this.resizeToPayload.put("anchor", (Object)anchor);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
        this.connection.sendAction("resize-window", this.resizeToPayload, listener, this);
    }

    public void resizeTo(int width, int height, AckListener listener) throws DesktopException {
        this.resizeTo(width, height, "top-left", listener);
    }

    public void resizeBy(int deltaWidth, int deltaHeight, String anchor) throws DesktopException {
        try {
            this.resizeByPayload.put("deltaWidth", deltaWidth);
            this.resizeByPayload.put("deltaHeight", deltaHeight);
            this.resizeByPayload.put("anchor", (Object)anchor);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
        this.connection.sendAction("resize-window-by", this.resizeByPayload);
    }

    public void resizeBy(int deltaWidth, int deltaHeight, String anchor, AckListener listener) throws DesktopException {
        try {
            this.resizeByPayload.put("deltaWidth", deltaWidth);
            this.resizeByPayload.put("deltaHeight", deltaHeight);
            this.resizeByPayload.put("anchor", (Object)anchor);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
        this.connection.sendAction("resize-window-by", this.resizeByPayload, listener, this);
    }

    public void getState(AckListener listener) {
        this.connection.sendAction("get-window-state", this.noParamPayload, listener, this);
    }

    public void bringToFront(AckListener listener) {
        this.connection.sendAction("bring-window-to-front", this.noParamPayload, listener, this);
    }

    public void isShowing(AckListener listener) {
        this.connection.sendAction("is-window-showing", this.noParamPayload, listener, this);
    }

    public void getBounds(final AsyncCallback<WindowBounds> callback, final AckListener listener) {
        AckListener mainCallback = null;
        if (callback != null) {
            mainCallback = new AckListener(){

                public void onSuccess(Ack ack) {
                    try {
                        JSONObject jsonObject = ack.getJsonObject();
                        JSONObject data = JsonUtils.getJsonValue(jsonObject, "data", null);
                        WindowBounds bounds = new WindowBounds(JsonUtils.getIntegerValue(data, "top", null), JsonUtils.getIntegerValue(data, "left", null), JsonUtils.getIntegerValue(data, "width", null), JsonUtils.getIntegerValue(data, "height", null));
                        callback.onSuccess(bounds);
                    }
                    catch (Exception ex) {
                        logger.error("Error calling onSuccess", (Throwable)ex);
                    }
                }

                public void onError(Ack ack) {
                    DesktopUtils.errorAck(listener, ack);
                }
            };
        }
        this.connection.sendAction("get-window-bounds", this.noParamPayload, mainCallback, this);
    }

    public void setBounds(int left, int top, int width, int height, AckListener listener) {
        JSONObject setBoundsPayload = new JSONObject();
        try {
            setBoundsPayload.put("uuid", (Object)this.uuid);
            setBoundsPayload.put("name", (Object)this.name);
            setBoundsPayload.put("top", top);
            setBoundsPayload.put("left", left);
            setBoundsPayload.put("width", width);
            setBoundsPayload.put("height", height);
            this.connection.sendAction("set-window-bounds", setBoundsPayload, listener, this);
        }
        catch (Exception e) {
            logger.error("Error setting bounds", (Throwable)e);
            DesktopUtils.errorAckOnException(listener, setBoundsPayload, e);
        }
    }

    public void bringToFront() throws DesktopException {
        this.connection.sendAction("bring-window-to-front", this.noParamPayload);
    }

    public void updateOptions(WindowOptions options, AckListener listener) {
        JSONObject payload = new JSONObject();
        try {
            payload.put("uuid", (Object)this.uuid);
            payload.put("name", (Object)this.uuid);
            payload.put("options", (Object)options.getJson());
        }
        catch (JSONException e) {
            DesktopUtils.errorAckOnException(listener, payload, (Exception)((Object)e));
        }
        this.connection.sendAction("update-window-options", payload, listener, this);
    }

    public void getOptions(final AsyncCallback<WindowOptions> callback, AckListener listener) {
        AckListener mainCallback = null;
        if (callback != null) {
            mainCallback = new AckListener(){

                public void onSuccess(Ack ack) {
                    try {
                        JSONObject jsonObject = ack.getJsonObject();
                        WindowOptions options = new WindowOptions(JsonUtils.getJsonValue(jsonObject, "data", null));
                        callback.onSuccess(options);
                    }
                    catch (Exception ex) {
                        logger.error("Error calling onSuccess", (Throwable)ex);
                    }
                }

                public void onError(Ack ack) {
                }
            };
        }
        this.connection.sendAction("get-window-options", this.noParamPayload, mainCallback, this);
    }

    public void setAsForeground(AckListener callback) {
        this.connection.sendAction("set-foreground-window", this.noParamPayload, callback, this);
    }

    public void enableFrame(AckListener callback) {
        this.connection.sendAction("enable-window-frame", this.noParamPayload, callback, this);
    }

    public void disableFrame(AckListener callback) {
        this.connection.sendAction("disable-window-frame", this.noParamPayload, callback, this);
    }

    public void updateOptions(JSONObject options) throws DesktopException {
        JSONObject payload = new JSONObject();
        try {
            payload.put("uuid", (Object)this.uuid);
            payload.put("name", (Object)this.name);
            payload.put("options", (Object)options);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
        this.connection.sendAction("update-window-options", payload);
    }

    public void getNativeId(AckListener listener) {
        JSONObject payload = new JSONObject();
        try {
            payload.put("uuid", (Object)this.uuid);
            payload.put("name", (Object)this.name);
        }
        catch (JSONException e) {
            logger.error("Error setting nativeId", (Throwable)e);
        }
        this.connection.sendAction("get-window-native-id", payload, listener, this);
    }

    public static Window wrap(String applicationUuid, String windowName, DesktopConnection connection) {
        return new Window(applicationUuid, windowName, connection);
    }

    public void joinGroup(Window window) throws DesktopException {
        JSONObject payload = new JSONObject();
        try {
            payload.put("uuid", (Object)this.uuid);
            payload.put("name", (Object)this.name);
            payload.put("groupingUuid", (Object)window.uuid);
            payload.put("groupingWindowName", (Object)window.name);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
        this.connection.sendAction("join-window-group", payload);
    }

    public void joinGroup(Window window, AckListener callback) {
        JSONObject payload = new JSONObject();
        try {
            payload.put("uuid", (Object)this.uuid);
            payload.put("name", (Object)this.name);
            payload.put("groupingUuid", (Object)window.uuid);
            payload.put("groupingWindowName", (Object)window.name);
        }
        catch (JSONException e) {
            logger.error("Error joining group", (Throwable)e);
        }
        this.connection.sendAction("join-window-group", payload, callback, this);
    }

    public void mergeGroups(Window window) throws DesktopException {
        JSONObject payload = new JSONObject();
        try {
            payload.put("uuid", (Object)this.uuid);
            payload.put("name", (Object)this.name);
            payload.put("groupingUuid", (Object)window.uuid);
            payload.put("groupingWindowName", (Object)window.name);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
        this.connection.sendAction("merge-window-groups", payload);
    }

    public void mergeGroups(Window window, AckListener callback) {
        JSONObject payload = new JSONObject();
        try {
            payload.put("uuid", (Object)this.uuid);
            payload.put("name", (Object)this.name);
            payload.put("groupingUuid", (Object)window.uuid);
            payload.put("groupingWindowName", (Object)window.name);
        }
        catch (JSONException e) {
            DesktopUtils.errorAckOnException(callback, payload, (Exception)((Object)e));
        }
        this.connection.sendAction("merge-window-groups", payload, callback, this);
    }

    public void leaveGroup() throws DesktopException {
        JSONObject payload = new JSONObject();
        try {
            payload.put("uuid", (Object)this.uuid);
            payload.put("name", (Object)this.name);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
        this.connection.sendAction("leave-window-group", payload);
    }

    public void leaveGroup(AckListener callback) {
        JSONObject payload = new JSONObject();
        try {
            payload.put("uuid", (Object)this.uuid);
            payload.put("name", (Object)this.name);
        }
        catch (JSONException e) {
            logger.error("Error leaving group", (Throwable)e);
        }
        this.connection.sendAction("leave-window-group", payload, callback, this);
    }

    public void animate(AnimationTransitions transitions, AnimationOptions options, AckListener callback) {
        JSONObject animationPayload = new JSONObject();
        try {
            animationPayload.put("uuid", (Object)this.uuid);
            animationPayload.put("name", (Object)this.name);
            if (transitions != null) {
                animationPayload.put("transitions", (Object)transitions.toJsonObject());
            }
            if (options != null) {
                animationPayload.put("options", (Object)options.getOptions());
            }
            this.connection.sendAction("animate-window", animationPayload, callback, this);
        }
        catch (Exception e) {
            logger.error("Error animating", (Throwable)e);
        }
    }

    public void getGroup(final AsyncCallback<List<Window>> groupHandler, final AckListener callback) {
        if (groupHandler != null) {
            JSONObject payload = new JSONObject();
            payload.put("uuid", (Object)this.uuid);
            payload.put("name", (Object)this.name);
            payload.put("crossApp", true);
            this.connection.sendAction("get-window-group", payload, new AckListener(){

                public void onSuccess(Ack ack) {
                    ArrayList<Window> list = new ArrayList<Window>();
                    try {
                        JSONObject value = ack.getJsonObject();
                        if (value != null) {
                            JSONArray array = value.getJSONArray("data");
                            for (int i = 0; i < array.length(); ++i) {
                                JSONObject item = array.getJSONObject(i);
                                list.add(Window.wrap(item.getString("uuid"), item.getString("windowName"), Window.this.connection));
                            }
                        }
                        groupHandler.onSuccess(list);
                    }
                    catch (Exception e) {
                        logger.error("Error processing group", (Throwable)e);
                    }
                }

                public void onError(Ack ack) {
                    DesktopUtils.errorAck(callback, ack);
                }
            }, this);
        }
    }

    private void addEventListener(JSONObject subscriptionObject, EventListener listener, AckListener callback) {
        this.connection.addEventCallback(subscriptionObject, listener, callback, this);
    }

    public void addEventListener(String type, EventListener listener, AckListener callback) {
        JSONObject eventListenerPayload = new JSONObject();
        try {
            eventListenerPayload.put("uuid", (Object)this.getUuid());
            eventListenerPayload.put("name", (Object)this.getName());
            eventListenerPayload.put("topic", (Object)"window");
            eventListenerPayload.put("type", (Object)type);
            this.addEventListener(eventListenerPayload, listener, callback);
        }
        catch (Exception e) {
            logger.error("Error adding eventListener", (Throwable)e);
        }
    }

    public void removeEventListener(String type, EventListener listener, AckListener callback) {
        try {
            JSONObject eventListenerPayload = new JSONObject();
            eventListenerPayload.put("uuid", (Object)this.getUuid());
            eventListenerPayload.put("name", (Object)this.getName());
            eventListenerPayload.put("topic", (Object)"window");
            eventListenerPayload.put("type", (Object)type);
            this.connection.removeEventCallback(eventListenerPayload, listener, callback, this);
        }
        catch (Exception e) {
            logger.error("Error removing event listener", (Throwable)e);
        }
    }
}

