/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.RuntimeConfiguration;
import com.openfin.desktop.System;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeLauncher {
    private static final Logger logger = LoggerFactory.getLogger((String)RuntimeLauncher.class.getName());
    private static final String INSTALLER_FILENAME = "OpenFinInstaller";
    private static final String RVM_FILENAME = "OpenFinRVM";
    private static final String WIN_LOCAL_APP_DATA = "LOCALAPPDATA";
    private static final String INSTALLER_TMP_DIR_PROP = "com.openfin.temp";
    private static final String INSTALLER_LOC_PROP = "com.openfin.installer.location";
    private static String INSTALLER_TMP_DIR;
    private static String INSTALLER_LOCATION;
    private static final boolean needExtractInstaller;
    private static final String OpenFinRvmRegistryKey = "HKEY_CURRENT_USER\\SOFTWARE\\OpenFin\\RVM";
    private static final String WorkingDirRegistryValueName = "installDir";
    private static final String InstallDirectory = "OpenFin";
    private static final String ADAPTER_VERSION_LOCATION;
    private static final String INSTALLER_SECURITY_SCAN_WAIT_TIME_PROP = "openfin.installer.scan.wait.time";
    private static long INSTALLER_SECURITY_SCAN_WAIT_TIME;

    public static void launchConfig(String runtimeConfigUrl) {
        if (runtimeConfigUrl == null) {
            throw new IllegalArgumentException("Desktop config must be specified ");
        }
        try {
            if (!RuntimeLauncher.getExistingRuntime()) {
                RuntimeLauncher.extractInstaller("OpenFinInstaller.exe");
            }
            RuntimeLauncher.runDesktop(runtimeConfigUrl);
        }
        catch (Exception e) {
            logger.error("Exception in launchConfig", (Throwable)e);
        }
    }

    public static void launchVersion(RuntimeConfiguration configuration) throws IOException {
        if (configuration.getRuntimeVersion() == null) {
            throw new IllegalArgumentException("Desktop version must be specified ");
        }
        if (!RuntimeLauncher.getExistingRuntime()) {
            RuntimeLauncher.extractInstaller("OpenFinInstaller.exe");
        }
        StringBuffer installerArguments = new StringBuffer(" --no-installer-ui --config=\"" + RuntimeLauncher.createRVMConfig(configuration) + "\"");
        if (configuration.getRuntimeAssetURL() != null && configuration.getRuntimeAssetURL().length() > 0) {
            installerArguments.append(" --assetsUrl=\"" + configuration.getRuntimeAssetURL() + "\"");
        }
        if (configuration.getAdditionalRvmArguments() != null && configuration.getAdditionalRvmArguments().length() > 0) {
            installerArguments.append(configuration.getAdditionalRvmArguments());
        }
        RuntimeLauncher.runDesktop(installerArguments.toString());
    }

    private static boolean getExistingRuntime() {
        boolean existing = false;
        try {
            String exitingV = RuntimeLauncher.getCachedVersion();
            String currentV = System.getAdapterVersion();
            if (exitingV != null && currentV != null && currentV.equals(exitingV)) {
                File vfile = new File(INSTALLER_LOCATION);
                if (vfile.exists()) {
                    existing = true;
                    logger.info("already exists, skip unpacking " + INSTALLER_LOCATION);
                }
            } else {
                logger.debug("outdated cached adapter version, unpacking installer");
            }
        }
        catch (Exception e) {
            logger.debug("Exception from getExistingRuntime", (Throwable)e);
        }
        return existing;
    }

    private static String getCachedVersion() {
        String version = null;
        try {
            File vfile = new File(ADAPTER_VERSION_LOCATION);
            if (vfile.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(vfile));
                version = reader.readLine();
                reader.close();
            }
        }
        catch (Exception e) {
            logger.debug("Exception in getCachedVersion", (Throwable)e);
        }
        logger.debug("found cached adapter version " + version + " current version " + System.getAdapterVersion());
        return version;
    }

    private static void extractInstaller(String zipName) {
        try {
            if (needExtractInstaller) {
                logger.info("loading resource " + zipName);
                InputStream in = RuntimeLauncher.class.getClassLoader().getResourceAsStream(zipName);
                if (in != null) {
                    RuntimeLauncher.createDir(INSTALLER_TMP_DIR);
                    String filePath = INSTALLER_TMP_DIR + File.separator + zipName;
                    RuntimeLauncher.extractFile(in, filePath);
                    in.close();
                    RuntimeLauncher.updateCachedVersion();
                } else {
                    logger.error("resource " + zipName + " missing ");
                }
            } else {
                logger.info("do not need to extract " + zipName);
            }
        }
        catch (Exception e) {
            logger.error("Exception in extractZip", (Throwable)e);
        }
    }

    private static void installRVM() {
        String rvmExe = "OpenFinRVM.exe";
        try {
            if (needExtractInstaller) {
                logger.info("loading resource " + rvmExe);
                InputStream in = RuntimeLauncher.class.getClassLoader().getResourceAsStream(rvmExe);
                if (in != null) {
                    RuntimeLauncher.createDir(INSTALLER_TMP_DIR);
                    String filePath = INSTALLER_TMP_DIR + File.separator + rvmExe;
                    RuntimeLauncher.extractFile(in, filePath);
                    in.close();
                    RuntimeLauncher.updateCachedVersion();
                } else {
                    logger.error("resource " + rvmExe + " missing ");
                }
            } else {
                logger.info("do not need to extract " + rvmExe);
            }
        }
        catch (Exception e) {
            logger.error("Exception in installRVM", (Throwable)e);
        }
    }

    private static void updateCachedVersion() {
        String version = System.getAdapterVersion();
        if (version != null) {
            try {
                logger.debug("Updating " + ADAPTER_VERSION_LOCATION);
                File vfile = new File(ADAPTER_VERSION_LOCATION);
                BufferedWriter writer = new BufferedWriter(new FileWriter(vfile, false));
                writer.write(version);
                writer.close();
            }
            catch (Exception e) {
                logger.debug("Exception in updateCachedVersion", (Throwable)e);
            }
            logger.debug("set existing adapter version " + version);
        }
    }

    private static void createDir(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            logger.debug("creating dirs " + path);
            dir.mkdirs();
        }
    }

    private static void extractFile(InputStream zipIn, String filePath) throws IOException {
        logger.info("extracting " + filePath);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[2048];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
        if (INSTALLER_SECURITY_SCAN_WAIT_TIME > 0L) {
            logger.debug("sleep to wait for security scan " + INSTALLER_SECURITY_SCAN_WAIT_TIME);
            try {
                Thread.sleep(INSTALLER_SECURITY_SCAN_WAIT_TIME);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private static void runDesktop(final String runtimeOptions) throws IOException {
        Thread thread = new Thread(){

            public void run() {
                try {
                    String executable = INSTALLER_LOCATION;
                    logger.info("starting: " + executable + " " + runtimeOptions);
                    StringTokenizer tokenizer = new StringTokenizer(runtimeOptions, " ");
                    ArrayList<String> args = new ArrayList<String>();
                    args.add(executable);
                    while (tokenizer.hasMoreTokens()) {
                        args.add(tokenizer.nextToken());
                    }
                    ProcessBuilder pb = new ProcessBuilder(args);
                    Process process = pb.start();
                    StreamReader seInfo = new StreamReader(process.getInputStream(), false);
                    StreamReader seError = new StreamReader(process.getErrorStream(), true);
                    seInfo.start();
                    seError.start();
                    int status = process.waitFor();
                    seInfo.join();
                    seError.join();
                    logger.debug("launching process returned " + status);
                }
                catch (Exception ex) {
                    logger.debug("Exception in runDesktop thread", (Throwable)ex);
                }
                logger.debug("runDesktop thread exiting");
            }
        };
        thread.setName(RuntimeLauncher.class.getName() + ".runDesktop");
        thread.start();
    }

    private static String createRVMConfig(RuntimeConfiguration configuration) throws IOException {
        String configText = configuration.generateRuntimeConfig();
        logger.debug(configText);
        File configFile = File.createTempFile("OFJava-" + UUID.randomUUID().toString(), ".json");
        PrintWriter out = new PrintWriter(configFile);
        out.print(configText);
        out.close();
        return configFile.getAbsolutePath();
    }

    public static void main2(String[] args) throws URISyntaxException, IOException, InterruptedException {
        String RUNTIME_APP_CONFIG = "OpenFinAppConfig";
        String RUNTIME_VERSION = "OpenFinRelease";
        String runOptions = java.lang.System.getProperty(RUNTIME_APP_CONFIG);
        String runtimeVersion = java.lang.System.getProperty(RUNTIME_VERSION);
        java.lang.System.out.println(java.lang.System.getProperty(INSTALLER_LOC_PROP));
    }

    static {
        INSTALLER_SECURITY_SCAN_WAIT_TIME = 0L;
        INSTALLER_LOCATION = java.lang.System.getProperty(INSTALLER_LOC_PROP) != null ? java.lang.System.getProperty(INSTALLER_LOC_PROP) : null;
        INSTALLER_TMP_DIR = java.lang.System.getProperty(INSTALLER_TMP_DIR_PROP) != null ? java.lang.System.getProperty(INSTALLER_TMP_DIR_PROP) : java.lang.System.getProperty("java.io.tmpdir");
        if (INSTALLER_LOCATION == null) {
            INSTALLER_TMP_DIR = INSTALLER_TMP_DIR + File.separator + "openfinjava";
            INSTALLER_LOCATION = INSTALLER_TMP_DIR + File.separator + INSTALLER_FILENAME + ".exe";
            needExtractInstaller = true;
        } else {
            needExtractInstaller = false;
        }
        ADAPTER_VERSION_LOCATION = INSTALLER_TMP_DIR + File.separator + INSTALLER_FILENAME + "JavaAdapter.ver";
        String waitTime = java.lang.System.getProperty(INSTALLER_SECURITY_SCAN_WAIT_TIME_PROP);
        if (waitTime != null) {
            INSTALLER_SECURITY_SCAN_WAIT_TIME = Long.parseLong(waitTime);
        }
    }

    private static class StreamReader
    extends Thread {
        private InputStream in;
        private boolean isErrorStream;

        StreamReader(InputStream in, boolean isErrorStream) {
            this.in = in;
            this.isErrorStream = isErrorStream;
            this.setName(RuntimeLauncher.class.getName() + ".streamReader");
        }

        public void run() {
            logger.debug("starting");
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(this.in));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (this.isErrorStream) {
                        logger.error(line);
                        continue;
                    }
                    logger.debug(line);
                }
            }
            catch (Exception e) {
                logger.error("Error reading stream", (Throwable)e);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    logger.error("Error closing stream", (Throwable)e);
                }
            }
            logger.debug("exiting");
        }
    }
}

