/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.ExternalMessageResultHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalMessageResultHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)ExternalMessageResultHandlerFactory.class.getName());
    private Map<String, ResultHandlerMetaInfo> handlers = new HashMap<String, ResultHandlerMetaInfo>();
    private DesktopConnection desktopConnection;
    private String uuid;
    private JSONObject request;
    private boolean sentToDesktop = false;
    private int nHandlers = 0;
    private int nProcessed = 0;
    private boolean allDispatched = false;

    public ExternalMessageResultHandlerFactory(String uuid, DesktopConnection desktopConnection, JSONObject request) {
        this.request = request;
        this.desktopConnection = desktopConnection;
        this.uuid = uuid;
    }

    private void sendIfAllResultsDispatchedAndComplete() {
        if (this.allDispatched && this.nProcessed == this.nHandlers) {
            boolean totalResult = true;
            String totalMessage = "";
            if (this.nHandlers == 0) {
                totalResult = false;
                totalMessage = "No external message handler has been registered!";
            }
            for (Map.Entry<String, ResultHandlerMetaInfo> entry : this.handlers.entrySet()) {
                totalResult &= entry.getValue().result;
                totalMessage = totalMessage + entry.getValue().message;
            }
            try {
                JSONObject payload = new JSONObject();
                payload.put("uuid", (Object)this.uuid);
                payload.put("connectionId", this.request.getInt("connectionId"));
                payload.put("result", totalResult);
                payload.put("message", (Object)totalMessage);
                String action = "external-message-result";
                this.desktopConnection.sendAction(action, payload);
                this.sentToDesktop = true;
            }
            catch (Exception ex) {
                logger.error("Error", (Throwable)ex);
            }
        }
    }

    public synchronized void allDispatched() {
        this.allDispatched = true;
        this.sendIfAllResultsDispatchedAndComplete();
    }

    public synchronized ExternalMessageResultHandler makeResultHandler() {
        ExternalMessageResultHandlerImpl requestHandler = new ExternalMessageResultHandlerImpl(this);
        this.handlers.put(requestHandler.getId(), new ResultHandlerMetaInfo());
        ++this.nHandlers;
        return requestHandler;
    }

    public synchronized boolean handleResult(String id, boolean result, String message) {
        boolean handled = false;
        ResultHandlerMetaInfo handlerMetaInfo = this.handlers.get(id);
        if (!this.sentToDesktop && handlerMetaInfo != null && !handlerMetaInfo.processed) {
            handlerMetaInfo.processed = true;
            handlerMetaInfo.result = result;
            handlerMetaInfo.message = message;
            handled = true;
            ++this.nProcessed;
            this.sendIfAllResultsDispatchedAndComplete();
        }
        return handled;
    }

    private static class ExternalMessageResultHandlerImpl
    implements ExternalMessageResultHandler {
        private String id;
        private boolean sent;
        private ExternalMessageResultHandlerFactory externalMessageResultHandlerFactory;

        public ExternalMessageResultHandlerImpl(ExternalMessageResultHandlerFactory externalMessageResultHandlerFactory) {
            this.externalMessageResultHandlerFactory = externalMessageResultHandlerFactory;
            this.sent = false;
            this.id = UUID.randomUUID().toString();
        }

        public String getId() {
            return this.id;
        }

        public boolean send(boolean result, String message) {
            boolean didSend = false;
            if (!this.sent) {
                this.sent = true;
                didSend = this.externalMessageResultHandlerFactory.handleResult(this.id, result, message);
            }
            return didSend;
        }
    }

    private static class ResultHandlerMetaInfo {
        public boolean processed = false;
        public boolean result = true;
        public String message = "";
    }
}

