package com.openfin.desktop.animation;

import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *  class representing a transition of a Window's position.
 *  The left property represents the resulting left position of the window.
 *  The Top property represents the resulting top position of the window
 *  The Duration property represents the total time in milliseconds
 */
public class PositionTransition extends AbstractAnimation {
    private final static Logger logger = LoggerFactory.getLogger(PositionTransition.class.getName());

    /**
     * Empty constructor
     */
    public PositionTransition() {}


    public PositionTransition(Integer left, Integer top, Integer duration) {
        this.setLeft(left);
        this.setTop(top);
        this.setDuration(duration);
    }

    /**
     * Gets value of left
     * @return Value of left
     */
    public Integer getLeft() {
        Integer value = null;
        try {
            value = this.jsonObject.getInt("left");
        } catch (Exception e) {
            logger.error("Error getting left", e);
        }
        return value;
    }

    /**
     * Sets value of left
     * @param left Value of left
     */
    public void setLeft(Integer left) {
        try {
            this.jsonObject.put("left", left);
        } catch (Exception e) {
            logger.error("Error setting left", e);
        }
    }

    /**
     * Gets value of top
     * @return Value of top
     */
    public Integer getTop() {
        Integer value = null;
        try {
            value = this.jsonObject.getInt("top");
        } catch (Exception e) {
            logger.error("Error getting top", e);
        }
        return value;
    }

    /**
     * Sets value of top
     * @param top Value of top
     */
    public void setTop(Integer top) {
        try {
            this.jsonObject.put("top", top);
        } catch (Exception e) {
            logger.error("Error setting top", e);
        }
    }

    /**
     * Gets value of duration
     * @return Value of duration
     */
    public Integer getDuration() {
        Integer value = null;
        try {
            value = this.jsonObject.getInt("duration");
        } catch (Exception e) {
            logger.error("Error getting duration", e);
        }
        return value;
    }

    /**
     * Sets value of duration
     * @param duration Value of duration
     */
    public void setDuration(Integer duration) {
        try {
            this.jsonObject.put("duration", duration);
        } catch (Exception e) {
            logger.error("Error setting duration", e);
        }
    }

}
