package com.openfin.desktop;

/**
 *  listener interface for receiving status updates from AppDesktop.
 */
public interface DesktopStateListener {
    /**
     * Callback when Desktop is successfully connected and ready to
     * accept commands.
     */
    public void onReady();

    /**
     * Callback when connection is successfully closed
     * accept commands.
     */
    public void onClose();

    /**
     * Callback when client cannot start or connect to the Desktop.
     * @param reason Error message
     */
    public void onError(String reason);

    /**
     * Callback when a message is sent to this client
     * @param message Message text
     */
    public void onMessage(String message);

    /**
     * Callback when a message is sent from this client
     * @param message Message text
     */
    public void onOutgoingMessage(String message);
}
