package cn.zoecloud.core.operation;

import cn.zoecloud.core.ClientException;
import cn.zoecloud.core.ServiceException;
import cn.zoecloud.core.auth.Credential;
import cn.zoecloud.core.model.*;
import cn.zoecloud.core.service.HttpMethod;
import cn.zoecloud.core.service.RequestMessage;
import cn.zoecloud.core.service.ServiceClient;
import com.alibaba.fastjson.JSON;

import static cn.zoecloud.core.internal.ZoeCloudResponseParsers.*;

/**
 * 节目的操作
 * @author Leo
 */
public class ZoeCloudProgramOperation extends ZoeCloudOperation {
    private static final String LAYOUT_PATH = "/api/2.0/layouts";
    private static final String PUBLISH_PATH = LAYOUT_PATH + "/publish";

    public ZoeCloudProgramOperation(ServiceClient client, Credential credential, String endpoint) {
        super(client, credential, endpoint);
    }

    /**
     * 分页获取节目布局信息
     * @param getLayoutPageRequest
     * @return
     * @throws ServiceException
     * @throws ClientException
     */
    public GetLayoutPageResult getLayoutPage(GetLayoutPageRequest getLayoutPageRequest)
            throws ServiceException, ClientException {
        assert (getLayoutPageRequest != null);
        String url = String.format("%s?page=%d&size=%d", LAYOUT_PATH,
                getLayoutPageRequest.getPageRequest().getPageNumber(),
                getLayoutPageRequest.getPageRequest().getPageSize());
        RequestMessage request = new RequestMessage(this.getEndpoint(), url);
        return doOperation(request, getLayoutPageResponseParser);
    }

    /**
     * 节目发布
     * @param programPublishRequest
     * @return
     * @throws ServiceException
     * @throws ClientException
     */
    public ProgramPublishResult programPublish(ProgramPublishRequest programPublishRequest)
            throws ServiceException, ClientException {
        assert (programPublishRequest != null);
        RequestMessage request = new RequestMessage(this.getEndpoint(), PUBLISH_PATH);
        request.setMethod(HttpMethod.POST);
        request.setBody(JSON.toJSONString(programPublishRequest));
        return doOperation(request, programPublishResponseParser);
    }

    /**
     * 获取节目发布状态信息
     * @param getProgramPublishStatusRequest
     * @return
     * @throws ServiceException
     * @throws ClientException
     */
    public GetProgramPublishStatusResult getProgramPublishStatus(
            GetProgramPublishStatusRequest getProgramPublishStatusRequest) throws ServiceException, ClientException {
        assert (getProgramPublishStatusRequest != null);
        String url = String.format("%s/%s", PUBLISH_PATH, getProgramPublishStatusRequest.getPublishId());
        RequestMessage request = new RequestMessage(this.getEndpoint(), url);
        return doOperation(request, getProgramPublishStatusResponseParser);
    }

    /**
     * 获取节目发布详情
     * @param getProgramPublishDetailRequest
     * @return
     * @throws ServiceException
     * @throws ClientException
     */
    public GetProgramPublishDetailResult getProgramPublishDetail(
            GetProgramPublishDetailRequest getProgramPublishDetailRequest) throws ServiceException, ClientException {
        assert (getProgramPublishDetailRequest != null);
        String url = String.format("%s/%s/details", PUBLISH_PATH, getProgramPublishDetailRequest.getPublishId());
        RequestMessage request = new RequestMessage(this.getEndpoint(), url);
        return doOperation(request, getProgramPublishDetailResponseParser);
    }
}
