package cn.zoecloud.core.model;

import com.alibaba.fastjson.annotation.JSONField;

import java.util.List;

/**
 * 发布节目的请求
 * @author Leo
 */
public class ProgramPublishRequest {
    private String layoutId;
    private String title;
    private List<String> terminalIds;
    private List<Area> areas;

    public String getLayoutId() {
        return layoutId;
    }

    public void setLayoutId(String layoutId) {
        this.layoutId = layoutId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getTerminalIds() {
        return terminalIds;
    }

    public void setTerminalIds(List<String> terminalIds) {
        this.terminalIds = terminalIds;
    }

    public List<Area> getAreas() {
        return areas;
    }

    public void setAreas(List<Area> areas) {
        this.areas = areas;
    }

    public static class Area {
        private String areaName;
        private List<Material> materials;

        public String getAreaName() {
            return areaName;
        }

        public void setAreaName(String areaName) {
            this.areaName = areaName;
        }

        public List<Material> getMaterials() {
            return materials;
        }

        public void setMaterials(List<Material> materials) {
            this.materials = materials;
        }
    }

    public static class Material {
        private MaterialType type;
        private String url;
        private Long size;
        private Integer durationSeconds;

        @JSONField(serialize = false)
        public MaterialType getType() {
            return type;
        }

        @JSONField(name = "type")
        public String getTypeStr() {
            return type == null ? null : type.toString().toLowerCase();
        }

        public void setType(MaterialType type) {
            this.type = type;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Long getSize() {
            return size;
        }

        public void setSize(Long size) {
            this.size = size;
        }

        public Integer getDurationSeconds() {
            return durationSeconds;
        }

        public void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }
    }
}
