package cn.zoecloud.core.model;

import com.alibaba.fastjson.annotation.JSONField;

import java.util.Date;
import java.util.List;

/**
 * 节目信息
 * @author Leo
 */
public class ProgramInfo {
    private String name;
    private Integer playMode;
    private Integer playDuration;
    private Integer playCount;
    private List<Timing> playTimings;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PlayMode getPlayMode() {
        return PlayMode.findOne(playMode);
    }

    public void setPlayMode(Integer playMode) {
        this.playMode = playMode;
    }

    public Integer getPlayDuration() {
        return playDuration;
    }

    public void setPlayDuration(Integer playDuration) {
        this.playDuration = playDuration;
    }

    public Integer getPlayCount() {
        return playCount;
    }

    public void setPlayCount(Integer playCount) {
        this.playCount = playCount;
    }

    public List<Timing> getPlayTimings() {
        return playTimings;
    }

    public void setPlayTimings(List<Timing> playTimings) {
        this.playTimings = playTimings;
    }

    /**
     * 节目定时播放信息
     */
    public static class Timing {
        @JSONField(format = "yyyy-MM-dd'T'HH:mm:ss.SSSZ")
        private Date start;
        @JSONField(format = "yyyy-MM-dd'T'HH:mm:ss.SSSZ")
        private Date end;
        private Boolean weekLimited;
        private String weekFlag;

        public Date getStart() {
            return start;
        }

        public void setStart(Date start) {
            this.start = start;
        }

        public Date getEnd() {
            return end;
        }

        public void setEnd(Date end) {
            this.end = end;
        }

        public Boolean getWeekLimited() {
            return weekLimited;
        }

        public void setWeekLimited(Boolean weekLimited) {
            this.weekLimited = weekLimited;
        }

        public String getWeekFlag() {
            return weekFlag;
        }

        public void setWeekFlag(String weekFlag) {
            this.weekFlag = weekFlag;
        }
    }
}
