package cn.zoecloud.core.model;

import org.apache.commons.lang3.StringUtils;

/**
 * 命令状态
 * @author Leo
 */
public enum CommandStatus {
    SENDING, PROCESSING, SUCCESSFUL, FAILED;

    public static CommandStatus findOne(String status) {
        if (StringUtils.isBlank(status)) {
            return null;
        }

        if (StringUtils.equalsIgnoreCase(status, SENDING.toString())) {
            return SENDING;
        } else if (StringUtils.equalsIgnoreCase(status, PROCESSING.toString())) {
            return PROCESSING;
        } else if (StringUtils.equalsIgnoreCase(status, SUCCESSFUL.toString())) {
            return SUCCESSFUL;
        } else if (StringUtils.equalsIgnoreCase(status, FAILED.toString())) {
            return FAILED;
        }
        return null;
    }
}
