package cn.zoecloud.core.model;

import org.apache.commons.lang3.StringUtils;

/**
 * 命令
 * @author Leo
 */
public enum Command {
    OPEN_SCREEN, CLOSE_SCREEN, SCREEN_STATUS, SCREEN_CAPTURE, FETCH_PROGRAMS;

    public static Command findOne(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }

        if (StringUtils.equalsIgnoreCase(code, OPEN_SCREEN.toString())) {
            return OPEN_SCREEN;
        } else if (StringUtils.equalsIgnoreCase(code, CLOSE_SCREEN.toString())) {
            return CLOSE_SCREEN;
        } else if (StringUtils.equalsIgnoreCase(code, SCREEN_STATUS.toString())) {
            return SCREEN_STATUS;
        } else if (StringUtils.equalsIgnoreCase(code, SCREEN_CAPTURE.toString())) {
            return SCREEN_CAPTURE;
        } else if (StringUtils.equalsIgnoreCase(code, FETCH_PROGRAMS.toString())) {
            return FETCH_PROGRAMS;
        }
        return null;
    }
}
